/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axenvoy.listeners;

import com.artillexstudios.axenvoy.envoy.Envoy;
import com.artillexstudios.axenvoy.envoy.Envoys;
import com.artillexstudios.axenvoy.envoy.SpawnedCrate;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class BlockPhysicsListener
implements Listener {
    @EventHandler
    public void onBlockPhysicsEvent(@NotNull BlockPhysicsEvent event) {
        Collection<Envoy> envoys = Envoys.getTypes().values();
        if (envoys.isEmpty()) {
            return;
        }
        for (Envoy envoy : envoys) {
            ArrayList<SpawnedCrate> spawnedCrate;
            if (!envoy.isActive() || !envoy.getCenter().getWorld().equals((Object)event.getBlock().getWorld()) || (spawnedCrate = envoy.getSpawnedCrates()).isEmpty()) continue;
            int spawnedCrateSize = spawnedCrate.size();
            for (int i1 = 0; i1 < spawnedCrateSize; ++i1) {
                SpawnedCrate crate = spawnedCrate.get(i1);
                BlockFace[] faces = BlockFace.values();
                int faceSize = faces.length;
                for (int i2 = 0; i2 < faceSize; ++i2) {
                    Block relative = crate.getFinishLocation().getBlock().getRelative(faces[i2]);
                    if (!(relative.getLocation().distanceSquared(event.getSourceBlock().getLocation()) <= 4.0)) continue;
                    event.setCancelled(true);
                    return;
                }
            }
        }
    }

    @EventHandler
    public void onEntityChangeBlockEvent(EntityChangeBlockEvent event) {
        if (!event.getEntity().getPersistentDataContainer().has(SpawnedCrate.FALLING_BLOCK_KEY, PersistentDataType.BYTE)) {
            return;
        }
        event.setCancelled(true);
        event.getEntity().remove();
    }
}

