/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axenvoy.libs.axapi.reflection;

import com.artillexstudios.axenvoy.libs.axapi.reflection.ClassUtils;
import com.artillexstudios.axenvoy.libs.axapi.reflection.accessor.AccessorType;
import com.artillexstudios.axenvoy.libs.axapi.utils.UncheckedUtils;
import com.artillexstudios.axenvoy.libs.axapi.utils.logging.LogUtils;
import java.lang.reflect.Field;
import java.util.Arrays;

public interface FieldAccessor {
    public static Builder builder() {
        return new Builder();
    }

    public void set(Object var1, Object var2);

    public void setVolatile(Object var1, Object var2);

    public Object get(Object var1);

    default public <T> T get(Object instance, Class<T> clazz) {
        try {
            return clazz.cast(this.get(instance));
        }
        catch (ClassCastException exception) {
            LogUtils.error("Failed to get field due to mismatching type!", exception);
            throw exception;
        }
    }

    default public <T> T getUnchecked(Object instance) {
        return UncheckedUtils.unsafeCast(this.get(instance));
    }

    public Object getVolatile(Object var1);

    default public <T> T getVolatile(Object instance, Class<T> clazz) {
        return clazz.cast(this.getVolatile(instance));
    }

    default public <T> T getVolatileUnchecked(Object instance) {
        return UncheckedUtils.unsafeCast(this.getVolatile(instance));
    }

    public static class Builder {
        private AccessorType type = AccessorType.FIELD;
        private Class<?> clazz = null;
        private Field field = null;
        private String fieldName = null;
        private Class<?> fieldType = null;
        private Integer fieldIndex = null;
        private boolean silent = false;

        public Builder methodHandle() {
            this.type = AccessorType.METHOD_HANDLE;
            return this;
        }

        public Builder varHandle() {
            this.type = AccessorType.VAR_HANDLE;
            return this;
        }

        public Builder reflect() {
            this.type = AccessorType.FIELD;
            return this;
        }

        public Builder silent() {
            this.silent = true;
            return this;
        }

        public Builder withClass(Class<?> clazz) {
            this.clazz = clazz;
            this.tryFetchField();
            return this;
        }

        public Builder withClass(String clazz) {
            this.clazz = ClassUtils.INSTANCE.getClassOrNull(clazz);
            this.tryFetchField();
            return this;
        }

        public Builder withField(Field field) {
            this.field = field;
            return this;
        }

        public Builder withField(String field) {
            this.fieldName = field;
            this.tryFetchField();
            return this;
        }

        public Builder withFieldType(Class<?> type, int index) {
            this.fieldType = type;
            this.fieldIndex = index;
            this.tryFetchField();
            return this;
        }

        private void tryFetchField() {
            if (this.clazz == null) {
                return;
            }
            if (this.fieldName != null) {
                this.fetchByName();
            } else if (this.fieldType != null) {
                this.fetchByType();
            }
            if (this.field == null) {
                return;
            }
            this.field.setAccessible(true);
            this.fieldType = null;
            this.fieldName = null;
            this.fieldIndex = null;
        }

        private void fetchByName() {
            try {
                this.field = this.clazz.getDeclaredField(this.fieldName);
            }
            catch (NoSuchFieldException exception) {
                if (this.silent) {
                    return;
                }
                LogUtils.error("Failed to find field {} of class {}! Fields of class: {}", this.fieldName, this.clazz.getName(), String.join((CharSequence)", ", Arrays.stream(this.clazz.getDeclaredFields()).map(Field::getName).toList()), exception);
                throw new RuntimeException(exception);
            }
        }

        private void fetchByType() {
            Field[] fields = (Field[])Arrays.stream(this.clazz.getDeclaredFields()).filter(field -> field.getType().equals(this.fieldType)).toArray(Field[]::new);
            if (this.fieldIndex >= fields.length) {
                LogUtils.error("Failed to find field with type {} and index {} of class {}! Fields of class: {}", this.fieldType, this.fieldIndex, this.clazz.getName(), String.join((CharSequence)", ", Arrays.stream(this.clazz.getDeclaredFields()).map(Field::getName).toList()));
                return;
            }
            this.field = fields[this.fieldIndex];
        }

        public FieldAccessor build() {
            if (this.field == null) {
                return null;
            }
            try {
                return this.type.createNew(this.field);
            }
            catch (IllegalAccessException exception) {
                if (this.silent) {
                    return null;
                }
                throw new RuntimeException(exception);
            }
        }
    }
}

