/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axenvoy.envoy;

import com.artillexstudios.axenvoy.AxEnvoyPlugin;
import com.artillexstudios.axenvoy.config.impl.Config;
import com.artillexstudios.axenvoy.envoy.CrateType;
import com.artillexstudios.axenvoy.envoy.Envoy;
import com.artillexstudios.axenvoy.event.EnvoyCrateCollectEvent;
import com.artillexstudios.axenvoy.integrations.blocks.BlockIntegration;
import com.artillexstudios.axenvoy.libs.axapi.hologram.Hologram;
import com.artillexstudios.axenvoy.libs.axapi.hologram.HologramType;
import com.artillexstudios.axenvoy.libs.axapi.hologram.HologramTypes;
import com.artillexstudios.axenvoy.libs.axapi.hologram.page.HologramPage;
import com.artillexstudios.axenvoy.libs.axapi.packetentity.meta.entity.DisplayMeta;
import com.artillexstudios.axenvoy.libs.axapi.packetentity.meta.entity.TextDisplayMeta;
import com.artillexstudios.axenvoy.libs.axapi.scheduler.ScheduledTask;
import com.artillexstudios.axenvoy.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axenvoy.rewards.Reward;
import com.artillexstudios.axenvoy.user.User;
import com.artillexstudios.axenvoy.utils.FallingBlockChecker;
import com.artillexstudios.axenvoy.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vex;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpawnedCrate {
    public static final NamespacedKey FIREWORK_KEY = new NamespacedKey((Plugin)AxEnvoyPlugin.getInstance(), "axenvoy_firework");
    public static final NamespacedKey FALLING_BLOCK_KEY = new NamespacedKey((Plugin)AxEnvoyPlugin.getInstance(), "axenvoy_falling_block");
    private final Envoy parent;
    private final CrateType handle;
    private Location finishLocation;
    private FallingBlock fallingBlock;
    private Vex vex;
    private Hologram hologram;
    private int tick = 0;
    private int health;

    public SpawnedCrate(@NotNull Envoy parent, @NotNull CrateType handle, @NotNull Location location) {
        this.health = handle.getConfig().REQUIRED_INTERACTION_AMOUNT;
        this.parent = parent;
        this.handle = handle;
        this.finishLocation = location;
        this.parent.getSpawnedCrates().add(this);
        Scheduler.get().runAt(location, task -> {
            List<Entity> nearby = null;
            boolean chunkLoaded = location.getWorld().isChunkLoaded(location.getBlockX() >> 4, location.getBlockZ() >> 4);
            if (handle.getConfig().FALLING_BLOCK_ENABLED && chunkLoaded) {
                nearby = location.getWorld().getNearbyEntities(location, (double)(Bukkit.getServer().getSimulationDistance() * 16), (double)(Bukkit.getServer().getSimulationDistance() * 16), (double)(Bukkit.getServer().getSimulationDistance() * 16)).stream().filter(entity -> entity.getType() == EntityType.PLAYER).toList();
            }
            if (!handle.getConfig().FALLING_BLOCK_ENABLED || nearby == null) {
                this.land(location);
                return;
            }
            Location spawnAt = location.clone();
            spawnAt.add(0.5, this.handle.getConfig().FALLING_BLOCK_HEIGHT, 0.5);
            this.vex = (Vex)location.getWorld().spawn(spawnAt, Vex.class, ent -> {
                ent.setInvisible(true);
                ent.setSilent(true);
                ent.setInvulnerable(true);
                ent.setGravity(true);
                ent.setAware(false);
                ent.setPersistent(false);
                if (ent.getEquipment() != null) {
                    ent.getEquipment().clear();
                }
            });
            this.vex.setGravity(true);
            this.fallingBlock = location.getWorld().spawnFallingBlock(spawnAt, Material.matchMaterial((String)this.handle.getConfig().FALLING_BLOCK_BLOCK.toUpperCase(Locale.ENGLISH)).createBlockData());
            this.vex.addPassenger((Entity)this.fallingBlock);
            this.fallingBlock.setPersistent(false);
            this.fallingBlock.getPersistentDataContainer().set(FALLING_BLOCK_KEY, PersistentDataType.BYTE, (Object)0);
            FallingBlockChecker.addToCheck(this);
            this.vex.setVelocity(new Vector(0.0, handle.getConfig().FALLING_BLOCK_SPEED, 0.0));
        });
    }

    public void land(@NotNull Location location) {
        if (Config.DONT_REPLACE_BLOCKS) {
            while (!(location.getBlock().getType().equals((Object)Material.AIR) || location.getBlock().getType().equals((Object)Material.VOID_AIR) || location.getBlock().getType().equals((Object)Material.CAVE_AIR) || location.getY() >= (double)location.getWorld().getMaxHeight())) {
                location.add(0.0, 1.0, 0.0);
            }
        }
        this.finishLocation = location;
        BlockIntegration.Companion.place(this.handle.getConfig().BLOCK_TYPE, location);
        this.updateHologram();
        this.spawnFirework(location);
    }

    private void updateHologram() {
        if (!this.handle.getConfig().HOLOGRAM_ENABLED) {
            return;
        }
        if (this.hologram == null) {
            Location hologramLocation = this.finishLocation.clone().add(0.5, 0.0, 0.5);
            hologramLocation.add(0.0, this.handle.getConfig().HOLOGRAM_HEIGHT, 0.0);
            this.hologram = new Hologram(hologramLocation);
            HologramPage<String, HologramType<String>> page = this.hologram.createPage(HologramTypes.TEXT);
            page.getParameters().withParameter(SpawnedCrate.class, this);
            page.setEntityMetaHandler(m -> {
                TextDisplayMeta meta = (TextDisplayMeta)m;
                meta.seeThrough(false);
                meta.alignment(TextDisplayMeta.Alignment.CENTER);
                meta.billboardConstrain(DisplayMeta.BillboardConstrain.VERTICAL);
                meta.backgroundColor(Integer.parseInt("00000000", 16));
                meta.lineWidth(1000);
            });
            ArrayList<String> transformed = new ArrayList<String>();
            for (String line : this.handle.getConfig().HOLOGRAM_LINES) {
                transformed.add(line.replace("%max_hits%", String.valueOf(this.getHandle().getConfig().REQUIRED_INTERACTION_AMOUNT)));
            }
            page.setContent(String.join((CharSequence)"<reset><br>", transformed));
            page.spawn();
        }
    }

    public void claim(@Nullable Player player, Envoy envoy) {
        this.claim(player, envoy, true);
    }

    public void spawnFirework(Location location) {
        if (!this.handle.getConfig().FIREWORK_ENABLED) {
            return;
        }
        Scheduler.get().executeAt(location, () -> {
            Location loc2 = location.clone();
            loc2.add(0.5, 0.5, 0.5);
            Firework fw = (Firework)location.getWorld().spawnEntity(loc2, EntityType.FIREWORK);
            FireworkMeta meta = fw.getFireworkMeta();
            meta.addEffect(FireworkEffect.builder().with(this.handle.getFireworkType()).withColor(Color.fromRGB((int)this.handle.getFireworkColor().getRed(), (int)this.handle.getFireworkColor().getGreen(), (int)this.handle.getFireworkColor().getBlue())).build());
            meta.setPower(0);
            fw.setFireworkMeta(meta);
            fw.getPersistentDataContainer().set(FIREWORK_KEY, PersistentDataType.BYTE, (Object)0);
            fw.detonate();
        });
    }

    public void damage(User user, Envoy envoy) {
        if (user.canCollect(envoy, this.getHandle())) {
            --this.health;
            if (this.health == 0) {
                this.claim(user.getPlayer(), envoy);
            }
        } else {
            Utils.sendMessage((CommandSender)user.getPlayer(), envoy.getConfig().PREFIX, envoy.getConfig().COOLDOWN.replace("%player%", user.getPlayer().getName()).replace("%player_name%", user.getPlayer().getName()).replace("%crate%", this.getHandle().getConfig().DISPLAY_NAME).replace("%cooldown%", String.valueOf((user.getCollectCooldown(envoy, this.getHandle()) - System.currentTimeMillis()) / 1000L)));
        }
    }

    public void claim(@Nullable Player player, Envoy envoy, boolean remove) {
        ScheduledTask task;
        if (this.fallingBlock != null) {
            this.fallingBlock.remove();
            this.fallingBlock = null;
        }
        Reward finalReward = null;
        if (player != null) {
            int cooldown;
            ItemStack item = player.getInventory().getItemInMainHand();
            for (Reward reward : this.handle.getRewards()) {
                if (!reward.doesMatchRequired(item)) continue;
                finalReward = reward;
                item.setAmount(item.getAmount() - 1);
                break;
            }
            if (finalReward != null) {
                finalReward.execute(player, envoy);
            } else {
                for (int i = 0; i < this.handle.getRewardAmount(); ++i) {
                    Reward reward;
                    reward = this.handle.randomReward();
                    reward.execute(player, envoy);
                    finalReward = reward;
                }
            }
            Bukkit.getPluginManager().callEvent((Event)new EnvoyCrateCollectEvent(player, this.parent, this, finalReward));
            int n = cooldown = this.getHandle().getConfig().COLLECT_COOLDOWN > 0 ? this.getHandle().getConfig().COLLECT_COOLDOWN : envoy.getConfig().COLLECT_COOLDOWN;
            if (envoy.getConfig().COLLECT_GLOBAL_COOLDOWN) {
                cooldown = envoy.getConfig().COLLECT_COOLDOWN;
            }
            User.USER_MAP.get(player.getUniqueId()).addCrateCooldown(this.getHandle(), cooldown, envoy);
        }
        BlockIntegration.Companion.remove(this.getHandle().getConfig().BLOCK_TYPE, this.finishLocation);
        if (this.hologram != null) {
            this.hologram.remove();
        }
        if (remove) {
            this.parent.getSpawnedCrates().remove(this);
        }
        if ((task = this.parent.cancelTask()) != null) {
            task.cancel();
        }
        if (envoy != null) {
            boolean broadcast = envoy.getConfig().BROADCAST_COLLECT;
            if (!broadcast && this.handle.getConfig().BROADCAST_COLLECT) {
                broadcast = true;
            }
            if (broadcast && player != null && !this.parent.getSpawnedCrates().isEmpty()) {
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    if (onlinePlayer.getPersistentDataContainer().has(AxEnvoyPlugin.MESSAGE_KEY, PersistentDataType.BYTE)) continue;
                    Utils.sendMessage((CommandSender)onlinePlayer, envoy.getConfig().PREFIX, envoy.getConfig().COLLECT.replace("%reward%", finalReward.name()).replace("%player_name%", player.getName()).replace("%player%", player.getName()).replace("%crate%", this.handle.getConfig().DISPLAY_NAME).replace("%amount%", String.valueOf(envoy.getSpawnedCrates().size())));
                }
            }
            if (this.parent.getSpawnedCrates().isEmpty()) {
                envoy.updateNext();
                envoy.setActive(false);
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    Utils.sendMessage((CommandSender)onlinePlayer, envoy.getConfig().PREFIX, envoy.getConfig().ENDED);
                }
            }
        }
    }

    public void tickFlare() {
        if (!this.handle.getConfig().FLARE_ENABLED) {
            return;
        }
        if (this.handle.getConfig().FLARE_EVERY == 0L) {
            return;
        }
        ++this.tick;
        if ((long)this.tick == this.handle.getConfig().FLARE_EVERY) {
            Scheduler.get().executeAt(this.finishLocation, () -> {
                if (!this.getFinishLocation().getWorld().isChunkLoaded(this.getFinishLocation().getBlockX() >> 4, this.getFinishLocation().getBlockZ() >> 4)) {
                    return;
                }
                Location loc2 = this.finishLocation.clone();
                loc2.add(0.5, 0.5, 0.5);
                Firework fw = (Firework)loc2.getWorld().spawnEntity(loc2, EntityType.FIREWORK);
                FireworkMeta meta = fw.getFireworkMeta();
                meta.addEffect(FireworkEffect.builder().with(this.handle.getFlareFireworkType()).withColor(Color.fromRGB((int)this.handle.getFlareFireworkColor().getRed(), (int)this.handle.getFlareFireworkColor().getGreen(), (int)this.handle.getFlareFireworkColor().getBlue())).build());
                meta.setPower(0);
                fw.setFireworkMeta(meta);
                fw.getPersistentDataContainer().set(FIREWORK_KEY, PersistentDataType.BYTE, (Object)0);
                fw.detonate();
            });
            this.tick = 0;
        }
    }

    public Vex getVex() {
        return this.vex;
    }

    public void setVex(Vex vex) {
        this.vex = vex;
    }

    public CrateType getHandle() {
        return this.handle;
    }

    public FallingBlock getFallingBlock() {
        return this.fallingBlock;
    }

    public void setFallingBlock(FallingBlock fallingBlock) {
        this.fallingBlock = fallingBlock;
    }

    public Location getFinishLocation() {
        return this.finishLocation;
    }

    public int getHealth() {
        return this.health;
    }
}

