/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axenvoy.envoy;

import com.artillexstudios.axenvoy.envoy.Crates;
import com.artillexstudios.axenvoy.envoy.Envoy;
import com.artillexstudios.axenvoy.libs.axapi.scheduler.Scheduler;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Envoys {
    private static final Logger LOGGER = LoggerFactory.getLogger(Crates.class);
    private static final HashMap<String, Envoy> TYPES = new HashMap();
    private static final File CRATE_TYPES_FOLDER = com.artillexstudios.axenvoy.utils.FileUtils.PLUGIN_DIRECTORY.resolve("envoys/").toFile();
    private static boolean isReloading;

    public static void reload() {
        Scheduler.get().runAsync(() -> {
            if (isReloading) {
                return;
            }
            isReloading = true;
            if (CRATE_TYPES_FOLDER.mkdirs()) {
                com.artillexstudios.axenvoy.utils.FileUtils.copyFromResource("envoys");
            }
            Collection files = FileUtils.listFiles((File)CRATE_TYPES_FOLDER, (String[])new String[]{"yaml", "yml"}, (boolean)true);
            for (File file : files) {
                Envoy envoy = TYPES.get(file.getName().replace(".yml", "").replace(".yaml", ""));
                if (envoy == null) {
                    new Envoy(file);
                    continue;
                }
                envoy.reload();
            }
            ArrayList removedTypes = new ArrayList();
            TYPES.entrySet().removeIf(entry -> {
                boolean contains = files.contains(((Envoy)entry.getValue()).getFile());
                if (!contains) {
                    removedTypes.add((Envoy)entry.getValue());
                }
                isReloading = false;
                return !contains;
            });
            ArrayList<Envoy> envoyTypes = new ArrayList<Envoy>(Envoys.getTypes().values());
            int chestSize = envoyTypes.size();
            for (int i = 0; i < chestSize; ++i) {
                Envoy envoy = (Envoy)envoyTypes.get(i);
                if (removedTypes.contains(envoy)) {
                    envoy.stop();
                    continue;
                }
                envoy.reload();
            }
            isReloading = false;
        });
    }

    public static Envoy valueOf(String name) {
        return TYPES.get(name.toLowerCase(Locale.ENGLISH));
    }

    public static void register(Envoy envoy) {
        if (TYPES.containsKey(envoy.getName())) {
            LOGGER.warn("An envoy type named {} has already been registered! Skipping!", (Object)envoy.getName());
            return;
        }
        TYPES.put(envoy.getName().toLowerCase(Locale.ENGLISH), envoy);
    }

    public static Map<String, Envoy> getTypes() {
        return Map.copyOf(TYPES);
    }
}

