/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axenvoy.envoy;

import com.artillexstudios.axenvoy.envoy.CrateType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Crates {
    private static final Logger LOGGER = LoggerFactory.getLogger(Crates.class);
    private static final HashMap<String, CrateType> TYPES = new HashMap();
    private static final File CRATE_TYPES_FOLDER = com.artillexstudios.axenvoy.utils.FileUtils.PLUGIN_DIRECTORY.resolve("crates/").toFile();

    public static void reload() {
        if (CRATE_TYPES_FOLDER.mkdirs()) {
            com.artillexstudios.axenvoy.utils.FileUtils.copyFromResource("crates");
        }
        Collection files = FileUtils.listFiles((File)CRATE_TYPES_FOLDER, (String[])new String[]{"yaml", "yml"}, (boolean)true);
        for (File file : files) {
            CrateType crateType = TYPES.get(file.getName().replace(".yml", "").replace(".yaml", ""));
            if (crateType == null) {
                new CrateType(file);
                continue;
            }
            crateType.reload();
        }
        ArrayList removedTypes = new ArrayList();
        TYPES.entrySet().removeIf(entry -> {
            boolean contains = files.contains(((CrateType)entry.getValue()).getFile());
            if (!contains) {
                removedTypes.add((CrateType)entry.getValue());
            }
            return !contains;
        });
        ArrayList<CrateType> crateTypes = new ArrayList<CrateType>(Crates.getTypes().values());
        int chestSize = crateTypes.size();
        for (int i = 0; i < chestSize; ++i) {
            CrateType crateType = (CrateType)crateTypes.get(i);
            if (removedTypes.contains(crateType)) {
                crateType.remove();
                continue;
            }
            crateType.reload();
        }
    }

    public static CrateType valueOf(String name) {
        return TYPES.get(name.toLowerCase(Locale.ENGLISH));
    }

    public static void register(CrateType crateType) {
        if (TYPES.containsKey(crateType.getName())) {
            LOGGER.warn("A crate type named {} has already been registered! Skipping!", (Object)crateType.getName());
            return;
        }
        TYPES.put(crateType.getName().toLowerCase(Locale.ENGLISH), crateType);
    }

    public static Map<String, CrateType> getTypes() {
        return Map.copyOf(TYPES);
    }
}

