/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axenvoy.envoy;

import com.artillexstudios.axenvoy.config.impl.CrateConfig;
import com.artillexstudios.axenvoy.envoy.Crates;
import com.artillexstudios.axenvoy.envoy.Envoy;
import com.artillexstudios.axenvoy.envoy.Envoys;
import com.artillexstudios.axenvoy.envoy.SpawnedCrate;
import com.artillexstudios.axenvoy.libs.axapi.libs.math3.distribution.EnumeratedDistribution;
import com.artillexstudios.axenvoy.libs.axapi.libs.math3.util.Pair;
import com.artillexstudios.axenvoy.rewards.Reward;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.bukkit.FireworkEffect;
import org.jetbrains.annotations.NotNull;

public class CrateType {
    private final ArrayList<Reward> rewards = new ArrayList();
    private final File file;
    private final CrateConfig config;
    private final String name;
    private FireworkEffect.Type fireworkType;
    private FireworkEffect.Type flareFireworkType;
    private Color fireworkColor;
    private Color flareFireworkColor;
    private EnumeratedDistribution<Reward> reward;
    private int rewardAmount;

    public CrateType(@NotNull File file) {
        this.name = file.getName().replace(".yml", "").replace(".yaml", "");
        this.file = file;
        Crates.register(this);
        this.config = new CrateConfig("crates/" + file.getName());
        this.config.reload();
    }

    public Reward randomReward() {
        return (Reward)this.reward.sample();
    }

    public void reload() {
        this.config.reload();
        this.fireworkType = FireworkEffect.Type.valueOf((String)this.config.FIREWORK_TYPE.toUpperCase(Locale.ENGLISH));
        this.fireworkColor = new Color(Integer.valueOf(this.config.FIREWORK_COLOR.substring(1, 3), 16), Integer.valueOf(this.config.FIREWORK_COLOR.substring(3, 5), 16), Integer.valueOf(this.config.FIREWORK_COLOR.substring(5, 7), 16));
        this.flareFireworkColor = new Color(Integer.valueOf(this.config.FLARE_FIREWORK_COLOR.substring(1, 3), 16), Integer.valueOf(this.config.FLARE_FIREWORK_COLOR.substring(3, 5), 16), Integer.valueOf(this.config.FLARE_FIREWORK_COLOR.substring(5, 7), 16));
        this.flareFireworkType = FireworkEffect.Type.valueOf((String)this.config.FLARE_FIREWORK_TYPE.toUpperCase(Locale.ENGLISH));
        this.rewardAmount = this.config.REWARD_AMOUNT;
        ArrayList list = new ArrayList();
        for (Map<Object, Object> map : this.config.REWARDS) {
            HashMap hashMap = new HashMap();
            map.forEach((key, value) -> hashMap.put((String)key, value));
            list.add(hashMap);
        }
        this.rewards.clear();
        for (Map<Object, Object> map : list) {
            this.rewards.add(new Reward(((Number)map.getOrDefault("chance", 0)).doubleValue(), map.getOrDefault("commands", new ArrayList()), map.getOrDefault("messages", new ArrayList()), map.getOrDefault("items", new ArrayList()), (Map)map.get("required-item"), map.getOrDefault("sounds", new ArrayList()), (String)map.getOrDefault("name", "---")));
        }
        ArrayList<Pair> list1 = new ArrayList<Pair>();
        for (Reward reward : this.rewards) {
            if (reward.requiredItem() != null) continue;
            list1.add(new Pair((Object)reward, (Object)reward.chance()));
        }
        this.reward = new EnumeratedDistribution(list1);
    }

    public void remove() {
        Envoys.getTypes().forEach((name, envoy) -> {
            Iterator<SpawnedCrate> crateIterator = envoy.getSpawnedCrates().iterator();
            while (crateIterator.hasNext()) {
                SpawnedCrate next = crateIterator.next();
                if (!next.getHandle().equals(this)) continue;
                crateIterator.remove();
                next.claim(null, (Envoy)envoy, false);
            }
        });
    }

    public ArrayList<Reward> getRewards() {
        return this.rewards;
    }

    public File getFile() {
        return this.file;
    }

    public CrateConfig getConfig() {
        return this.config;
    }

    public Color getFireworkColor() {
        return this.fireworkColor;
    }

    public FireworkEffect.Type getFireworkType() {
        return this.fireworkType;
    }

    public FireworkEffect.Type getFlareFireworkType() {
        return this.flareFireworkType;
    }

    public Color getFlareFireworkColor() {
        return this.flareFireworkColor;
    }

    public String getName() {
        return this.name;
    }

    public int getRewardAmount() {
        return this.rewardAmount;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CrateType)) {
            return false;
        }
        CrateType crateType = (CrateType)object;
        return this.getFile().equals(crateType.getFile());
    }

    public int hashCode() {
        return this.getFile().hashCode();
    }
}

