/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axenvoy.config;

import com.artillexstudios.axenvoy.libs.axapi.config.Config;
import com.artillexstudios.axenvoy.libs.axapi.libs.boostedyaml.block.Block;
import com.artillexstudios.axenvoy.libs.axapi.libs.boostedyaml.block.implementation.Section;
import com.artillexstudios.axenvoy.libs.axapi.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.FlowStyle;
import com.artillexstudios.axenvoy.libs.axapi.libs.boostedyaml.settings.dumper.DumperSettings;
import com.artillexstudios.axenvoy.libs.axapi.libs.boostedyaml.settings.general.GeneralSettings;
import com.artillexstudios.axenvoy.libs.axapi.libs.boostedyaml.settings.loader.LoaderSettings;
import com.artillexstudios.axenvoy.libs.axapi.libs.boostedyaml.settings.updater.UpdaterSettings;
import com.artillexstudios.axenvoy.utils.FileUtils;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractConfig {
    private Config config;
    private AbstractConfig parent;

    public Config getConfig() {
        return this.config;
    }

    protected void reload(Path path, Class<? extends AbstractConfig> clazz, AbstractConfig instance, AbstractConfig parent) {
        this.config = new Config(path.toFile(), InputStream.nullInputStream(), GeneralSettings.builder().build(), LoaderSettings.builder().setDetailedErrors(true).build(), DumperSettings.builder().setEndMarker(false).setStartMarker(false).setFlowStyle(FlowStyle.BLOCK).build(), UpdaterSettings.builder().setAutoSave(true).build());
        this.parent = parent;
        Logger logger = LoggerFactory.getLogger(clazz);
        if (path.toFile().exists() && !FileUtils.getSuggestions(path.toFile(), logger)) {
            return;
        }
        try {
            this.getConfig().getBackingDocument().reload();
        }
        catch (Exception exception) {
            logger.error("Could not load yaml file: {}", (Object)path.toFile(), (Object)exception);
            return;
        }
        Arrays.stream(clazz.getDeclaredFields()).forEach(field -> {
            Key key = field.getDeclaredAnnotation(Key.class);
            Comment comment = field.getDeclaredAnnotation(Comment.class);
            if (key == null) {
                return;
            }
            try {
                Object object;
                Object value = this.getValue(key.value(), field.get(instance));
                if (field.getType() == String.class && !(value instanceof String)) {
                    value = String.valueOf(value);
                }
                if (value instanceof String) {
                    String str = (String)value;
                    object = StringEscapeUtils.unescapeJava((String)str);
                } else {
                    object = value;
                }
                field.set(instance, object);
                if (comment != null) {
                    this.setComment(key.value(), Arrays.asList(comment.value()));
                } else {
                    this.setComment(key.value(), null);
                }
            }
            catch (Throwable e) {
                logger.error("An issue occurred while loading file: {}", (Object)path.toFile(), (Object)e);
            }
        });
        try {
            this.getConfig().save();
        }
        catch (Exception e) {
            logger.error("An issue occurred while loading file: {}", (Object)path.toFile(), (Object)e);
        }
    }

    protected @Nullable Object getValue(String path, @Nullable Object def) {
        if (this.getConfig().get(path) == null) {
            if (this.parent != null) {
                return this.parent.get(path, def);
            }
            this.set(path, def);
        }
        return this.get(path, def);
    }

    protected void setComment(String path, @Nullable List<String> comment) {
        Block<?> block = this.getConfig().getBackingDocument().getBlock(path);
        if (block == null) {
            return;
        }
        if (comment != null) {
            block.setComments(comment);
        }
    }

    protected @Nullable Object get(String path, @Nullable Object def) {
        Object val = this.get(path);
        return val == null ? def : val;
    }

    protected @Nullable Object get(String path) {
        Object value = this.getConfig().get(path);
        if (!(value instanceof Section)) {
            return value;
        }
        Section section = (Section)value;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Object key : section.getKeys()) {
            Object rawValue = section.get(key.toString());
            if (rawValue == null) continue;
            map.put(key.toString(), rawValue);
        }
        return map;
    }

    protected void set(String path, @Nullable Object value) {
        this.getConfig().set(path, value);
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Key {
        public String value();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Comment {
        public String[] value();
    }
}

