/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axenvoy.blockfinder;

import com.artillexstudios.axenvoy.blockfinder.BlockFinder;
import com.artillexstudios.axenvoy.config.impl.Config;
import com.artillexstudios.axenvoy.config.impl.EnvoyConfig;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class IterativeBlockFinder
implements BlockFinder {
    private final Set<Material> passableBlocks = new HashSet<Material>();

    public IterativeBlockFinder() {
        for (String passableBlock : Config.PASSABLE_BLOCKS) {
            this.passableBlocks.add(Material.valueOf((String)passableBlock));
        }
    }

    @Override
    public Block highestBlockAt(Location location, EnvoyConfig config) {
        if (location == null || location.getWorld() == null) {
            return null;
        }
        for (int height = location.getWorld().getMaxHeight(); height >= location.getWorld().getMinHeight(); --height) {
            Block block = location.getWorld().getBlockAt(location.getBlockX(), height, location.getBlockZ());
            if (this.passableBlocks.contains(block.getType())) continue;
            return block;
        }
        return null;
    }
}

