/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axcalendar.utils;

import com.artillexstudios.axcalendar.AxCalendar;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;

public class TimeUtils {
    @NotNull
    public static String fancyTime(long time) {
        if (time < 0L) {
            return "---";
        }
        Duration remainingTime = Duration.ofMillis(time);
        long total = remainingTime.getSeconds();
        long days = total / 86400L;
        long hours = total % 86400L / 3600L;
        long minutes = total % 3600L / 60L;
        long seconds = total % 60L;
        if (AxCalendar.CONFIG.getInt("timer-format", 1) == 1) {
            if (days > 0L) {
                return String.format("%02d:%02d:%02d:%02d", days, hours, minutes, seconds);
            }
            if (hours > 0L) {
                return String.format("%02d:%02d:%02d", hours, minutes, seconds);
            }
            return String.format("%02d:%02d", minutes, seconds);
        }
        if (AxCalendar.CONFIG.getInt("timer-format", 1) == 2) {
            if (days > 0L) {
                return days + AxCalendar.LANG.getString("time.day", "d");
            }
            if (hours > 0L) {
                return hours + AxCalendar.LANG.getString("time.hour", "h");
            }
            if (minutes > 0L) {
                return minutes + AxCalendar.LANG.getString("time.minute", "m");
            }
            return seconds + AxCalendar.LANG.getString("time.second", "s");
        }
        if (days > 0L) {
            return String.format("%02d" + AxCalendar.LANG.getString("time.day", "d") + " %02d" + AxCalendar.LANG.getString("time.hour", "h") + " %02d" + AxCalendar.LANG.getString("time.minute", "m") + " %02d" + AxCalendar.LANG.getString("time.second", "s"), days, hours, minutes, seconds);
        }
        if (hours > 0L) {
            return String.format("%02d" + AxCalendar.LANG.getString("time.hour", "h") + " %02d" + AxCalendar.LANG.getString("time.minute", "m") + " %02d" + AxCalendar.LANG.getString("time.second", "s"), hours, minutes, seconds);
        }
        return String.format("%02d" + AxCalendar.LANG.getString("time.minute", "m") + " %02d" + AxCalendar.LANG.getString("time.second", "s"), minutes, seconds);
    }
}

