/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axcalendar.utils;

import com.artillexstudios.axcalendar.libs.axapi.libs.boostedyaml.block.implementation.Section;
import com.artillexstudios.axcalendar.libs.axapi.reflection.ClassUtils;
import com.artillexstudios.axcalendar.libs.axapi.utils.ItemBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ItemBuilderUtil {
    @NotNull
    @Contract(value="_ -> new")
    public static ItemBuilder newBuilder(@NotNull Section section) {
        return ItemBuilderUtil.newBuilder(section, Map.of());
    }

    @NotNull
    public static ItemBuilder newBuilder(@NotNull Section section, Map<String, String> replacements) {
        ItemBuilder builder = ItemBuilder.create(section);
        section.getOptionalString("name").ifPresent(name -> {
            if (ClassUtils.INSTANCE.classExists("me.clip.placeholderapi.PlaceholderAPI")) {
                name = PlaceholderAPI.setPlaceholders(null, (String)name);
            }
            builder.setName((String)name, replacements);
        });
        section.getOptionalStringList("lore").ifPresent(lore -> {
            if (ClassUtils.INSTANCE.classExists("me.clip.placeholderapi.PlaceholderAPI")) {
                lore = PlaceholderAPI.setPlaceholders(null, (List)lore);
            }
            builder.setLore((List<String>)lore, replacements);
        });
        return builder;
    }

    @NotNull
    @Contract(value="_ -> new")
    public static ItemBuilder newBuilder(@NotNull ItemStack itemStack) {
        return ItemBuilder.create(itemStack);
    }

    public static ItemStack parse(@NotNull ItemStack item, Map<String, String> replacements) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        Optional.of(meta.getDisplayName()).ifPresent(name -> {
            if (ClassUtils.INSTANCE.classExists("me.clip.placeholderapi.PlaceholderAPI")) {
                name = PlaceholderAPI.setPlaceholders(null, (String)name);
            }
            for (Map.Entry e : replacements.entrySet()) {
                name = name.replace((CharSequence)e.getKey(), (CharSequence)e.getValue());
            }
            meta.setDisplayName(name);
        });
        Optional.ofNullable(meta.getLore()).ifPresent(lore -> {
            if (ClassUtils.INSTANCE.classExists("me.clip.placeholderapi.PlaceholderAPI")) {
                lore = PlaceholderAPI.setPlaceholders(null, (List)lore);
            }
            for (Map.Entry e : replacements.entrySet()) {
                for (int i = 0; i < lore.size(); ++i) {
                    lore.set(i, ((String)lore.get(i)).replace((CharSequence)e.getKey(), (CharSequence)e.getValue()));
                }
            }
            meta.setLore(lore);
        });
        item.setItemMeta(meta);
        return item;
    }
}

