/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axcalendar.utils;

import com.artillexstudios.axcalendar.AxCalendar;
import java.time.Clock;
import java.time.Duration;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class CalendarUtils {
    private static ZoneId zoneId;
    private static int offset;

    public static void reload() {
        zoneId = !AxCalendar.CONFIG.getString("timezone", "").isEmpty() ? ZoneId.of(AxCalendar.CONFIG.getString("timezone", "")) : ZoneId.systemDefault();
        offset = AxCalendar.CONFIG.getInt("timezone-offset", 0);
    }

    public static int getDayOfMonth() {
        return CalendarUtils.getZonedDateTime().getDayOfMonth();
    }

    @NotNull
    public static ZonedDateTime getZonedDateTime() {
        ZonedDateTime zdt = ZonedDateTime.now(Clock.system(zoneId));
        zdt = zdt.plusHours(offset);
        return zdt;
    }

    public static boolean isSameMonth() {
        String month = AxCalendar.CONFIG.getString("month", "DECEMBER");
        return month.equalsIgnoreCase("AUTO") || CalendarUtils.getZonedDateTime().getMonth().getDisplayName(TextStyle.FULL, Locale.US).equalsIgnoreCase(month);
    }

    public static long getMilisUntilDay(int day) {
        String monthStr = AxCalendar.CONFIG.getString("month", "DECEMBER");
        Month month = monthStr.equalsIgnoreCase("AUTO") ? CalendarUtils.getZonedDateTime().getMonth() : Month.valueOf(monthStr);
        ZonedDateTime startOfTomorrow = CalendarUtils.getZonedDateTime().withMonth(month.getValue()).withDayOfMonth(day).toLocalDate().atStartOfDay(zoneId);
        Duration duration = Duration.between(CalendarUtils.getZonedDateTime(), startOfTomorrow);
        return duration.toMillis();
    }
}

