/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axcalendar.libs.lamp.util;

import com.artillexstudios.axcalendar.libs.lamp.util.Preconditions;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Suppliers {
    private Suppliers() {
    }

    @NotNull
    public static <T> Supplier<T> lazy(@NotNull Supplier<T> fetch) {
        Preconditions.notNull(fetch, "fetch supplier");
        return new LazySupplier<T>(fetch);
    }

    static final class LazySupplier<T>
    implements Supplier<T> {
        final Supplier<T> delegate;
        volatile transient boolean initialized;
        @Nullable
        transient T value;

        LazySupplier(Supplier<T> delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (!this.initialized) {
                LazySupplier lazySupplier = this;
                synchronized (lazySupplier) {
                    if (!this.initialized) {
                        T t = this.delegate.get();
                        this.value = t;
                        this.initialized = true;
                        return t;
                    }
                }
            }
            return this.value;
        }

        public String toString() {
            return "Suppliers.lazy(" + (this.initialized ? "<supplier that returned " + this.value + ">" : this.delegate) + ")";
        }
    }
}

