/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axcalendar.libs.lamp.util;

import com.artillexstudios.axcalendar.libs.lamp.command.ArgumentStack;
import com.artillexstudios.axcalendar.libs.lamp.exception.ArgumentParseException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class QuotedStringTokenizer {
    private static final List<String> EMPTY_TEXT = Collections.singletonList("");
    private static final int CHAR_BACKSLASH = 92;
    private static final int CHAR_SINGLE_QUOTE = 39;
    private static final int CHAR_DOUBLE_QUOTE = 34;

    private QuotedStringTokenizer() {
    }

    public static ArgumentStack parse(@NotNull String arguments) throws ArgumentParseException {
        if (arguments.length() == 0) {
            return ArgumentStack.empty();
        }
        TokenizerState state = new TokenizerState(arguments);
        ArgumentStack returnedArgs = ArgumentStack.empty();
        while (state.hasMore()) {
            QuotedStringTokenizer.skipWhiteSpace(state);
            String arg = QuotedStringTokenizer.nextArg(state);
            returnedArgs.add(arg);
        }
        return returnedArgs;
    }

    public static ArgumentStack parseForAutoCompletion(@NotNull String args) {
        if (args.isEmpty()) {
            return ArgumentStack.copyExact(EMPTY_TEXT);
        }
        return QuotedStringTokenizer.parse(args);
    }

    private static void skipWhiteSpace(TokenizerState state) throws ArgumentParseException {
        if (!state.hasMore()) {
            return;
        }
        if (Character.isWhitespace(state.peek())) {
            state.next();
        }
    }

    private static String nextArg(TokenizerState state) throws ArgumentParseException {
        StringBuilder argBuilder = new StringBuilder();
        if (state.hasMore()) {
            int codePoint = state.peek();
            if (codePoint == 34 || codePoint == 39) {
                QuotedStringTokenizer.parseQuotedString(state, codePoint, argBuilder);
            } else {
                QuotedStringTokenizer.parseUnquotedString(state, argBuilder);
            }
        }
        return argBuilder.toString();
    }

    private static void parseQuotedString(TokenizerState state, int startQuotation, StringBuilder builder) throws ArgumentParseException {
        int nextCodePoint = state.next();
        if (nextCodePoint != startQuotation) {
            throw state.createException(String.format("Actual next character '%c' did not match expected quotation character '%c'", nextCodePoint, startQuotation));
        }
        while (state.hasMore()) {
            nextCodePoint = state.peek();
            if (nextCodePoint == startQuotation) {
                state.next();
                return;
            }
            if (nextCodePoint == 92) {
                QuotedStringTokenizer.parseEscape(state, builder);
                continue;
            }
            builder.appendCodePoint(state.next());
        }
        return;
    }

    private static void parseUnquotedString(TokenizerState state, StringBuilder builder) throws ArgumentParseException {
        while (state.hasMore()) {
            int nextCodePoint = state.peek();
            if (Character.isWhitespace(nextCodePoint)) {
                return;
            }
            if (nextCodePoint == 92) {
                QuotedStringTokenizer.parseEscape(state, builder);
                continue;
            }
            builder.appendCodePoint(state.next());
        }
    }

    private static void parseEscape(TokenizerState state, StringBuilder builder) throws ArgumentParseException {
        state.next();
        builder.appendCodePoint(state.next());
    }

    private static class TokenizerState {
        private final String buffer;
        private int index = -1;

        TokenizerState(String buffer) {
            this.buffer = buffer;
        }

        public boolean hasMore() {
            return this.index + 1 < this.buffer.length();
        }

        public int peek() throws ArgumentParseException {
            if (!this.hasMore()) {
                throw this.createException("Buffer overrun while parsing args");
            }
            return this.buffer.codePointAt(this.index + 1);
        }

        public int next() throws ArgumentParseException {
            if (!this.hasMore()) {
                throw this.createException("Buffer overrun while parsing args");
            }
            return this.buffer.codePointAt(++this.index);
        }

        public ArgumentParseException createException(String message) {
            return new ArgumentParseException(message, this.buffer, this.index);
        }
    }
}

