/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axcalendar.libs.lamp.bukkit.brigadier;

import com.artillexstudios.axcalendar.libs.lamp.CommandHandler;
import com.artillexstudios.axcalendar.libs.lamp.autocomplete.SuggestionProvider;
import com.artillexstudios.axcalendar.libs.lamp.bukkit.BukkitBrigadier;
import com.artillexstudios.axcalendar.libs.lamp.bukkit.annotation.LiteralEnum;
import com.artillexstudios.axcalendar.libs.lamp.bukkit.brigadier.Node;
import com.artillexstudios.axcalendar.libs.lamp.bukkit.core.BukkitHandler;
import com.artillexstudios.axcalendar.libs.lamp.command.ArgumentStack;
import com.artillexstudios.axcalendar.libs.lamp.command.CommandActor;
import com.artillexstudios.axcalendar.libs.lamp.command.CommandCategory;
import com.artillexstudios.axcalendar.libs.lamp.command.CommandParameter;
import com.artillexstudios.axcalendar.libs.lamp.command.ExecutableCommand;
import com.artillexstudios.axcalendar.libs.lamp.command.trait.PermissionHolder;
import com.artillexstudios.axcalendar.libs.lamp.core.EitherParameter;
import com.artillexstudios.axcalendar.libs.lamp.exception.ArgumentParseException;
import com.artillexstudios.axcalendar.libs.lamp.util.Collections;
import com.artillexstudios.axcalendar.libs.lamp.util.Either;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class NodeParser {
    private final BukkitBrigadier brigadier;

    public NodeParser(BukkitBrigadier brigadier2) {
        this.brigadier = brigadier2;
    }

    private Node createNode(ArgumentBuilder<?, ?> builder) {
        return Node.from(builder);
    }

    public List<Node> parse(CommandHandler handler) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (CommandCategory category : handler.getCategories().values()) {
            if (!category.getPath().isRoot()) continue;
            nodes.add(this.create(category));
        }
        for (ExecutableCommand command : handler.getCommands().values()) {
            if (!command.getPath().isRoot()) continue;
            nodes.add(this.create(command));
        }
        return nodes;
    }

    private List<Node> createNodes(CommandParameter parameter) {
        if (parameter.isSwitch()) {
            String switchLiteral = parameter.getCommandHandler().getSwitchPrefix() + parameter.getSwitchName();
            return java.util.Collections.singletonList(this.createNode((ArgumentBuilder<?, ?>)LiteralArgumentBuilder.literal((String)switchLiteral)));
        }
        if (parameter.getType() == Either.class) {
            EitherParameter[] either = EitherParameter.create(parameter);
            List<Node> first = this.createNodes(either[0]);
            List<Node> second = this.createNodes(either[1]);
            return Stream.concat(first.stream(), second.stream()).collect(Collectors.toList());
        }
        if (parameter.getType().isEnum() && (parameter.hasAnnotation(LiteralEnum.class) || this.brigadier.isShowEnumsAsNativeLiterals())) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (Object v : parameter.getType().getEnumConstants()) {
                String name = ((Enum)v).name().toLowerCase();
                LiteralArgumentBuilder literal = LiteralArgumentBuilder.literal((String)name);
                nodes.add(Node.from(literal));
            }
            return nodes;
        }
        ExecutableCommand command = parameter.getDeclaringCommand();
        ArgumentType<?> argumentType = this.brigadier.getArgumentType(parameter);
        boolean isLast = parameter.getCommandIndex() == command.getValueParameters().size() - 1;
        Node node = this.createNode((ArgumentBuilder<?, ?>)RequiredArgumentBuilder.argument((String)parameter.getName(), argumentType));
        node.require(this.generateRequirement(parameter));
        node.suggest(NodeParser.createSuggestionProvider(this.brigadier, parameter));
        if (isLast) {
            node.canBeExecuted(this.brigadier);
        }
        return java.util.Collections.singletonList(node);
    }

    public Node create(CommandCategory category) {
        Node subNode;
        Node node = this.createNode((ArgumentBuilder<?, ?>)LiteralArgumentBuilder.literal((String)category.getName()));
        node.require(this.generateRequirement(category));
        for (CommandCategory subcategory : category.getCategories().values()) {
            subNode = this.create(subcategory);
            node.addChild(subNode);
        }
        for (ExecutableCommand subcommands : category.getCommands().values()) {
            subNode = this.create(subcommands);
            node.addChild(subNode);
        }
        if (category.getDefaultAction() != null) {
            this.addExecutables(category.getDefaultAction(), node);
        }
        return node;
    }

    private Predicate<Object> generateRequirement(PermissionHolder holder) {
        return sender -> holder.getPermission().canExecute(this.brigadier.wrapSource(sender));
    }

    public Node create(ExecutableCommand command) {
        Node node = this.createNode((ArgumentBuilder<?, ?>)LiteralArgumentBuilder.literal((String)command.getName()));
        node.require(this.generateRequirement(command));
        this.addExecutables(command, node);
        return node;
    }

    public void addExecutables(ExecutableCommand command, Node targetNode) {
        if (command.getValueParameters().isEmpty()) {
            targetNode.canBeExecuted(this.brigadier);
            return;
        }
        this.addParameterNodes(command, targetNode);
    }

    private void addParameterNodes(ExecutableCommand command, Node targetNode) {
        ArrayList lastNodes = (ArrayList)Collections.listOf(targetNode);
        ArrayList<CommandParameter> parameters = new ArrayList<CommandParameter>(command.getValueParameters().values());
        for (CommandParameter parameter : parameters) {
            List<Node> paramNodes;
            if (parameter.isFlag()) {
                this.addFlagParameter(parameter, lastNodes);
                continue;
            }
            if (parameter.isOptional() || parameter.isSwitch()) {
                lastNodes.forEach(lastNode -> lastNode.canBeExecuted(this.brigadier));
            }
            if ((paramNodes = this.createNodes(parameter)) == null || paramNodes.isEmpty()) continue;
            lastNodes.forEach(lastNode -> lastNode.addChildren(paramNodes));
            lastNodes.clear();
            lastNodes.addAll(paramNodes);
        }
    }

    private void addFlagParameter(CommandParameter parameter, ArrayList<Node> lastNodes) {
        Node flagLiteral = this.createNode((ArgumentBuilder<?, ?>)LiteralArgumentBuilder.literal((String)(parameter.getCommandHandler().getFlagPrefix() + parameter.getFlagName())));
        flagLiteral.require(this.generateRequirement(parameter));
        if (parameter.isOptional()) {
            lastNodes.forEach(lastNode -> lastNode.canBeExecuted(this.brigadier));
        }
        List<Node> flagNodes = this.createNodes(parameter);
        flagLiteral.addChildren(flagNodes);
        lastNodes.forEach(lastNode -> lastNode.addChild(flagLiteral));
        lastNodes.clear();
        lastNodes.addAll(flagNodes);
    }

    private static com.mojang.brigadier.suggestion.SuggestionProvider<Object> createSuggestionProvider(BukkitBrigadier brigadier2, CommandParameter parameter) {
        if (parameter.getSuggestionProvider() == SuggestionProvider.EMPTY) {
            return null;
        }
        if (brigadier2.isNativePlayerCompletionEnabled() && parameter.getSuggestionProvider() == BukkitHandler.playerSuggestionProvider) {
            return null;
        }
        return (context, builder) -> {
            try {
                CommandActor actor = brigadier2.wrapSource(context.getSource());
                String tooltipMessage = parameter.getDescription() == null ? parameter.getName() : parameter.getDescription();
                LiteralMessage tooltip = new LiteralMessage(tooltipMessage);
                String input = context.getInput();
                try {
                    ArgumentStack args = ArgumentStack.parseForAutoCompletion(input.startsWith("/") ? input.substring(1) : input);
                    parameter.getSuggestionProvider().getSuggestions(args, actor, parameter.getDeclaringCommand()).stream().filter(c2 -> c2.toLowerCase().startsWith(((String)args.getLast()).toLowerCase())).sorted(String.CASE_INSENSITIVE_ORDER).distinct().forEach(arg_0 -> NodeParser.lambda$null$6(builder, (Message)tooltip, arg_0));
                }
                catch (ArgumentParseException argumentParseException) {}
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return builder.buildFuture();
        };
    }

    private static /* synthetic */ void lambda$null$6(SuggestionsBuilder builder, Message tooltip, String c2) {
        builder.suggest(c2, tooltip);
    }
}

