/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axcalendar.libs.axapi.config.adapters.primitive;

import com.artillexstudios.axcalendar.libs.axapi.config.adapters.TypeAdapter;
import com.artillexstudios.axcalendar.libs.axapi.config.adapters.TypeAdapterHolder;
import java.lang.reflect.Type;

public final class FloatAdapter
implements TypeAdapter<Float, Float> {
    @Override
    public Float deserialize(TypeAdapterHolder registry, Object input, Type type) {
        if (input instanceof Number) {
            Number num = (Number)input;
            return this.validate(num);
        }
        if (input instanceof String) {
            String str = (String)input;
            return this.validate(Double.parseDouble(str));
        }
        throw new IllegalArgumentException("Can't make a float from a " + String.valueOf(input.getClass()));
    }

    private Float validate(Number number) {
        double doubleValue = number.doubleValue();
        if (doubleValue > 3.4028234663852886E38 || doubleValue < -3.4028234663852886E38) {
            throw new IllegalArgumentException("Float value is not actually a float! Should be between %s and %s, but was %s".formatted(Float.valueOf(-3.4028235E38f), Float.valueOf(Float.MAX_VALUE), doubleValue));
        }
        return Float.valueOf((float)doubleValue);
    }

    @Override
    public Float serialize(TypeAdapterHolder registry, Float value, Type type) {
        return value;
    }
}

