/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axcalendar.gui.impl;

import com.artillexstudios.axcalendar.AxCalendar;
import com.artillexstudios.axcalendar.enums.ClaimStatus;
import com.artillexstudios.axcalendar.gui.GuiFrame;
import com.artillexstudios.axcalendar.gui.data.Day;
import com.artillexstudios.axcalendar.gui.data.MenuManager;
import com.artillexstudios.axcalendar.gui.data.Reward;
import com.artillexstudios.axcalendar.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axcalendar.libs.axapi.utils.ContainerUtils;
import com.artillexstudios.axcalendar.libs.axapi.utils.ItemBuilder;
import com.artillexstudios.axcalendar.libs.axapi.utils.StringUtils;
import com.artillexstudios.axcalendar.libs.gui.builder.gui.SimpleBuilder;
import com.artillexstudios.axcalendar.libs.gui.guis.Gui;
import com.artillexstudios.axcalendar.libs.gui.guis.GuiItem;
import com.artillexstudios.axcalendar.utils.CalendarUtils;
import com.artillexstudios.axcalendar.utils.ItemBuilderUtil;
import com.artillexstudios.axcalendar.utils.RequirementUtils;
import com.artillexstudios.axcalendar.utils.SoundUtils;
import com.artillexstudios.axcalendar.utils.TimeUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CalendarGui
extends GuiFrame {
    private static final Set<CalendarGui> openMenus = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private final Gui gui;

    public CalendarGui(Player player) {
        super(AxCalendar.MENU, player);
        this.gui = ((SimpleBuilder)((SimpleBuilder)((SimpleBuilder)Gui.gui().title(StringUtils.format(AxCalendar.getPlaceholderParser().setPlaceholders((OfflinePlayer)player, AxCalendar.MENU.getString("title")), new TagResolver[0]))).rows(AxCalendar.MENU.getInt("rows", 6))).disableAllInteractions()).create();
        this.setGui(this.gui);
    }

    public void open() {
        CompletableFuture cf = new CompletableFuture();
        AxCalendar.getThreadedQueue().submit(() -> {
            if (this.file.getSection("close") != null) {
                super.createItem("close", event -> Scheduler.get().runAt(this.player.getLocation(), scheduledTask -> this.player.closeInventory()));
            }
            for (Map.Entry<Integer, Day> entry : MenuManager.getDays().entrySet()) {
                int num = entry.getKey();
                Day day = entry.getValue();
                HashMap<String, String> rp = new HashMap<String, String>();
                rp.put("%day%", "" + day.day());
                rp.put("%time%", TimeUtils.fancyTime(CalendarUtils.getMilisUntilDay(num)));
                switch (this.getClaimStatus(day)) {
                    case CLAIMED: {
                        GuiItem guiItem = new GuiItem(ItemBuilderUtil.parse(day.claimed().clone(), rp));
                        guiItem.setAction(event -> {
                            AxCalendar.MESSAGEUTILS.sendLang((CommandSender)this.player, "error.already-claimed", rp);
                            SoundUtils.playSound(this.player, AxCalendar.CONFIG.getString("sounds.failed"));
                        });
                        this.gui.setItem(day.slot(), guiItem);
                        break;
                    }
                    case CLAIMABLE: {
                        GuiItem guiItem = new GuiItem(ItemBuilderUtil.parse(day.claimable().clone(), rp));
                        guiItem.setAction(event -> AxCalendar.getThreadedQueue().submit(() -> {
                            if (this.getClaimStatus(day) != ClaimStatus.CLAIMABLE) {
                                return;
                            }
                            int maxIP = AxCalendar.CONFIG.getInt("max-accounts-per-ip", 3);
                            if (maxIP != -1 && maxIP <= AxCalendar.getDatabase().countIps(this.player, day)) {
                                AxCalendar.MESSAGEUTILS.sendLang((CommandSender)this.player, "error.too-many-ips", rp);
                                SoundUtils.playSound(this.player, AxCalendar.CONFIG.getString("sounds.failed"));
                                return;
                            }
                            if (!RequirementUtils.canClaim(this.player)) {
                                AxCalendar.MESSAGEUTILS.sendLang((CommandSender)this.player, "error.requirements-fail", rp);
                                SoundUtils.playSound(this.player, AxCalendar.CONFIG.getString("sounds.failed"));
                                return;
                            }
                            AxCalendar.getDatabase().claim(this.player, day);
                            Scheduler.get().run(scheduledTask -> {
                                SoundUtils.playSound(this.player, AxCalendar.CONFIG.getString("sounds.claimed"));
                                for (Reward reward : day.rewards()) {
                                    for (String string : reward.claimCommands()) {
                                        String string2 = string.replace("%player%", this.player.getName());
                                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)AxCalendar.getPlaceholderParser().setPlaceholders((OfflinePlayer)this.player, string2));
                                    }
                                    for (Map map : reward.claimItems()) {
                                        ItemStack it = ItemBuilder.create(map).get();
                                        ContainerUtils.INSTANCE.addOrDrop((Inventory)this.player.getInventory(), List.of(it), this.player.getLocation());
                                    }
                                    AxCalendar.MESSAGEUTILS.sendFormatted((CommandSender)this.player, AxCalendar.CONFIG.getString("prefix") + reward.message(), rp);
                                }
                            });
                            this.open();
                        }));
                        this.gui.setItem(day.slot(), guiItem);
                        break;
                    }
                    case UNCLAIMABLE: {
                        GuiItem guiItem = new GuiItem(ItemBuilderUtil.parse(day.unclaimable().clone(), rp));
                        guiItem.setAction(event -> {
                            AxCalendar.MESSAGEUTILS.sendLang((CommandSender)this.player, "error.too-early", rp);
                            SoundUtils.playSound(this.player, AxCalendar.CONFIG.getString("sounds.failed"));
                        });
                        this.gui.setItem(day.slot(), guiItem);
                        break;
                    }
                    case EXPIRED: {
                        GuiItem guiItem = new GuiItem(ItemBuilderUtil.parse(day.expired().clone(), rp));
                        guiItem.setAction(event -> {
                            AxCalendar.MESSAGEUTILS.sendLang((CommandSender)this.player, "error.too-late", rp);
                            SoundUtils.playSound(this.player, AxCalendar.CONFIG.getString("sounds.failed"));
                        });
                        this.gui.setItem(day.slot(), guiItem);
                    }
                }
            }
            cf.complete(null);
        });
        cf.thenRun(() -> {
            if (openMenus.contains(this)) {
                this.gui.update();
                this.updateTitle();
                return;
            }
            this.gui.setCloseGuiAction(e -> openMenus.remove(this));
            Scheduler.get().run(t -> {
                this.gui.open((HumanEntity)this.player);
                openMenus.add(this);
            });
        });
    }

    public ClaimStatus getClaimStatus(Day day) {
        if (AxCalendar.getDatabase().isClaimed(this.player, day)) {
            return ClaimStatus.CLAIMED;
        }
        if (!CalendarUtils.isSameMonth()) {
            return ClaimStatus.UNCLAIMABLE;
        }
        if (CalendarUtils.getDayOfMonth() == day.day()) {
            return ClaimStatus.CLAIMABLE;
        }
        boolean lateClaiming = AxCalendar.CONFIG.getBoolean("allow-late-claiming", true);
        if (CalendarUtils.getDayOfMonth() > day.day()) {
            return lateClaiming ? ClaimStatus.CLAIMABLE : ClaimStatus.EXPIRED;
        }
        return ClaimStatus.UNCLAIMABLE;
    }

    public static Set<CalendarGui> getOpenMenus() {
        return openMenus;
    }

    public Player getPlayer() {
        return this.player;
    }
}

