/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axcalendar.gui.data;

import com.artillexstudios.axcalendar.AxCalendar;
import com.artillexstudios.axcalendar.gui.GuiFrame;
import com.artillexstudios.axcalendar.gui.data.Day;
import com.artillexstudios.axcalendar.gui.data.Reward;
import com.artillexstudios.axcalendar.gui.impl.CalendarGui;
import com.artillexstudios.axcalendar.libs.axapi.libs.boostedyaml.block.implementation.Section;
import com.artillexstudios.axcalendar.libs.axapi.utils.ItemBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.HumanEntity;

public class MenuManager {
    private static final ConcurrentHashMap<Integer, Day> days = new ConcurrentHashMap();

    public static void reload() {
        IntArrayList dayNum;
        Section s;
        for (CalendarGui gui : CalendarGui.getOpenMenus()) {
            gui.getGui().close((HumanEntity)gui.getPlayer());
        }
        days.clear();
        for (String route : AxCalendar.MENU.getBackingDocument().getRoutesAsStrings(false)) {
            s = AxCalendar.MENU.getSection(route);
            if (s == null || (dayNum = GuiFrame.getSlots(s.getStringList("days"))).isEmpty()) continue;
            Section claimable = s.getSection("item-claimable");
            Section claimed = s.getSection("item-claimed");
            Section unclaimable = s.getSection("item-unclaimable");
            Section expired = s.getSection("item-expired");
            IntArrayList slots = GuiFrame.getSlots(s.getStringList("slot"));
            int idx = 0;
            for (Integer i : dayNum) {
                Day day = new Day(i, ItemBuilder.create(claimable).get(), ItemBuilder.create(claimed).get(), ItemBuilder.create(unclaimable).get(), ItemBuilder.create(expired).get(), slots.getInt(idx), new ArrayList<Reward>());
                days.put(i, day);
                ++idx;
            }
        }
        for (String route : AxCalendar.REWARDS.getBackingDocument().getRoutesAsStrings(false)) {
            s = AxCalendar.REWARDS.getSection(route);
            if (s == null || (dayNum = GuiFrame.getSlots(s.getStringList("days"))).isEmpty()) continue;
            Reward reward = new Reward(route, dayNum, s.getStringList("commands"), s.getMapList("items"), s.getString("message"));
            for (Integer i : dayNum) {
                Day day = days.get(i);
                if (day == null) continue;
                day.rewards().add(reward);
            }
        }
    }

    public static ConcurrentHashMap<Integer, Day> getDays() {
        return days;
    }
}

