/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axcalendar.gui;

import com.artillexstudios.axcalendar.libs.axapi.config.Config;
import com.artillexstudios.axcalendar.libs.axapi.libs.boostedyaml.block.implementation.Section;
import com.artillexstudios.axcalendar.libs.axapi.utils.NumberUtils;
import com.artillexstudios.axcalendar.libs.axapi.utils.StringUtils;
import com.artillexstudios.axcalendar.libs.gui.components.GuiAction;
import com.artillexstudios.axcalendar.libs.gui.guis.BaseGui;
import com.artillexstudios.axcalendar.libs.gui.guis.GuiItem;
import com.artillexstudios.axcalendar.utils.ItemBuilderUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiFrame {
    protected final Config file;
    protected BaseGui gui;
    protected Player player;

    public BaseGui getGui() {
        return this.gui;
    }

    public GuiFrame(Config file, Player player) {
        this.file = file;
        this.player = player;
    }

    public static IntArrayList getSlots(List<String> s) {
        IntArrayList slots = new IntArrayList();
        for (String str : s) {
            if (NumberUtils.isInt(str)) {
                slots.add(Integer.parseInt(str));
                continue;
            }
            String[] split = str.split("-");
            int min = Integer.parseInt(split[0]);
            int max = Integer.parseInt(split[1]);
            for (int i = min; i <= max; ++i) {
                slots.add(i);
            }
        }
        return slots;
    }

    public void setGui(BaseGui gui) {
        this.gui = gui;
        for (String str : this.file.getBackingDocument().getRoutesAsStrings(false)) {
            this.createItem(str);
        }
    }

    @NotNull
    public Config getFile() {
        return this.file;
    }

    protected ItemStack buildItem(@NotNull String key) {
        return this.buildItem(key, Map.of());
    }

    protected ItemStack buildItem(@NotNull String key, Map<String, String> replacements) {
        ItemMeta itemMeta;
        Section section = this.file.getSection(key);
        ItemStack item = ItemBuilderUtil.newBuilder(section, replacements).get();
        if (section.getOptionalString("texture").isEmpty() && (itemMeta = item.getItemMeta()) instanceof SkullMeta) {
            SkullMeta skullMeta = (SkullMeta)itemMeta;
            skullMeta.setOwningPlayer((OfflinePlayer)this.player);
            item.setItemMeta((ItemMeta)skullMeta);
        }
        return item;
    }

    protected void createItem(@NotNull String route) {
        this.createItem(route, (InventoryClickEvent event) -> {}, Map.of());
    }

    protected void createItem(@NotNull String route, @Nullable GuiAction<InventoryClickEvent> action) {
        this.createItem(route, action, Map.of());
    }

    protected void createItem(@NotNull String route, @Nullable GuiAction<InventoryClickEvent> action, Map<String, String> replacements) {
        if (this.file.getString(route + ".slot") == null && this.file.getStringList(route + ".slot").isEmpty()) {
            return;
        }
        if (this.file.getString(route + ".material") == null && this.file.getString(route + ".type") == null) {
            return;
        }
        List<String> slots = this.file.getBackingDocument().getStringList(route + ".slot");
        this.createItem(route, action, replacements, GuiFrame.getSlots(slots.isEmpty() ? List.of(this.file.getString(route + ".slot")) : slots));
    }

    protected void createItem(@NotNull String route, @Nullable GuiAction<InventoryClickEvent> action, Map<String, String> replacements, IntArrayList slots) {
        GuiItem guiItem = new GuiItem(this.buildItem(route, replacements), action);
        this.gui.setItem((List<Integer>)slots, guiItem);
    }

    protected void createItem(@NotNull String route, @NotNull ItemStack item, @Nullable GuiAction<InventoryClickEvent> action) {
        if (this.file.getSection(route) == null) {
            return;
        }
        GuiItem guiItem = new GuiItem(item, action);
        List<String> slots = this.file.getBackingDocument().getStringList(route + ".slot");
        this.gui.setItem((List<Integer>)GuiFrame.getSlots(slots.isEmpty() ? List.of(this.file.getString(route + ".slot")) : slots), guiItem);
    }

    protected void extendLore(ItemStack item, String ... lore) {
        ItemMeta meta = item.getItemMeta();
        ArrayList<String> newLore = new ArrayList<String>();
        if (meta.getLore() != null) {
            newLore.addAll(meta.getLore());
        }
        newLore.addAll(StringUtils.formatListToString(Arrays.asList(lore), new TagResolver[0]));
        meta.setLore(newLore);
        item.setItemMeta(meta);
    }

    public void updateTitle() {
    }
}

