/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axcalendar.database.impl;

import com.artillexstudios.axcalendar.AxCalendar;
import com.artillexstudios.axcalendar.database.impl.Base;
import com.artillexstudios.axcalendar.libs.hikari.HikariConfig;
import com.artillexstudios.axcalendar.libs.hikari.HikariDataSource;
import java.sql.Connection;

public class PostgreSQL
extends Base {
    private final HikariConfig hConfig = new HikariConfig();
    private HikariDataSource dataSource;

    @Override
    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public String getType() {
        return "PostgreSQL";
    }

    @Override
    public void setup() {
        this.hConfig.setPoolName("axrewards-pool");
        this.hConfig.setMaximumPoolSize(AxCalendar.CONFIG.getInt("database.pool.maximum-pool-size"));
        this.hConfig.setMinimumIdle(AxCalendar.CONFIG.getInt("database.pool.minimum-idle"));
        this.hConfig.setMaxLifetime((long)AxCalendar.CONFIG.getInt("database.pool.maximum-lifetime"));
        this.hConfig.setKeepaliveTime((long)AxCalendar.CONFIG.getInt("database.pool.keepalive-time"));
        this.hConfig.setConnectionTimeout((long)AxCalendar.CONFIG.getInt("database.pool.connection-timeout"));
        this.hConfig.setDriverClassName("com.artillexstudios.axcalendar.libs.postgresql.Driver");
        this.hConfig.setJdbcUrl("jdbc:postgresql://" + AxCalendar.CONFIG.getString("database.address") + ":" + AxCalendar.CONFIG.getString("database.port") + "/" + AxCalendar.CONFIG.getString("database.database"));
        this.hConfig.addDataSourceProperty("user", (Object)AxCalendar.CONFIG.getString("database.username"));
        this.hConfig.addDataSourceProperty("password", (Object)AxCalendar.CONFIG.getString("database.password"));
        this.dataSource = new HikariDataSource(this.hConfig);
        super.setup();
    }

    @Override
    public void disable() {
        try {
            this.dataSource.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

