/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axcalendar.database.impl;

import com.artillexstudios.axcalendar.database.Database;
import com.artillexstudios.axcalendar.gui.data.Day;
import com.artillexstudios.axcalendar.utils.IpUtils;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public abstract class Base
implements Database {
    private QueryRunner runner;
    private final String CREATE_TABLE = "        CREATE TABLE IF NOT EXISTS `axcalendar_data` (\n        \t`uuid` VARCHAR(36) NOT NULL,\n        \t`day` INT NOT NULL,\n        \t`ipv4` INT NOT NULL,\n        \tPRIMARY KEY (`uuid`,`day`)\n        );\n";
    private final String CLAIM = "        INSERT INTO axcalendar_data (`uuid`, `day`, `ipv4`) VALUES (?, ?, ?)\n";
    private final String IS_CLAIMED = "        SELECT count(*) FROM axcalendar_data WHERE `uuid` = ? AND `day` = ? LIMIT 1\n";
    private final String COUNT_IP = "        SELECT count(`ipv4`) FROM axcalendar_data WHERE `day` = ? AND `ipv4` = ?\n";
    private final String DELETE_USER = "        DELETE FROM axcalendar_data WHERE `uuid` = ?;\n";

    public abstract Connection getConnection();

    @Override
    public abstract String getType();

    public QueryRunner getRunner() {
        return this.runner;
    }

    @Override
    public void setup() {
        this.runner = new QueryRunner();
        try (Connection conn = this.getConnection();){
            this.runner.execute(conn, "        CREATE TABLE IF NOT EXISTS `axcalendar_data` (\n        \t`uuid` VARCHAR(36) NOT NULL,\n        \t`day` INT NOT NULL,\n        \t`ipv4` INT NOT NULL,\n        \tPRIMARY KEY (`uuid`,`day`)\n        );\n", new Object[0]);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void claim(@NotNull Player player, Day day) {
        try (Connection conn = this.getConnection();){
            this.runner.execute(conn, "        INSERT INTO axcalendar_data (`uuid`, `day`, `ipv4`) VALUES (?, ?, ?)\n", player.getUniqueId().toString(), day.day(), IpUtils.ipToInt(player));
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean isClaimed(@NotNull Player player, Day day) {
        boolean bl;
        block8: {
            ScalarHandler scalarHandler = new ScalarHandler();
            Connection conn = this.getConnection();
            try {
                boolean bl2 = bl = (Long)this.runner.query(conn, "        SELECT count(*) FROM axcalendar_data WHERE `uuid` = ? AND `day` = ? LIMIT 1\n", scalarHandler, player.getUniqueId().toString(), day.day()) != 0L;
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
            conn.close();
        }
        return bl;
    }

    @Override
    public int countIps(@NotNull Player player, Day day) {
        int n;
        block8: {
            ScalarHandler scalarHandler = new ScalarHandler();
            Connection conn = this.getConnection();
            try {
                n = Math.toIntExact((Long)this.runner.query(conn, "        SELECT count(`ipv4`) FROM axcalendar_data WHERE `day` = ? AND `ipv4` = ?\n", scalarHandler, day.day(), IpUtils.ipToInt(player)));
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    return 0;
                }
            }
            conn.close();
        }
        return n;
    }

    @Override
    public void reset(@NotNull OfflinePlayer player) {
        try (Connection conn = this.getConnection();){
            this.runner.execute(conn, "        DELETE FROM axcalendar_data WHERE `uuid` = ?;\n", player.getUniqueId().toString());
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public abstract void disable();
}

