/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axcalendar.commands;

import com.artillexstudios.axcalendar.AxCalendar;
import com.artillexstudios.axcalendar.commands.subcommands.Open;
import com.artillexstudios.axcalendar.commands.subcommands.Reload;
import com.artillexstudios.axcalendar.commands.subcommands.Reset;
import com.artillexstudios.axcalendar.libs.axapi.utils.StringUtils;
import com.artillexstudios.axcalendar.libs.lamp.annotation.DefaultFor;
import com.artillexstudios.axcalendar.libs.lamp.annotation.Subcommand;
import com.artillexstudios.axcalendar.libs.lamp.bukkit.BukkitCommandHandler;
import com.artillexstudios.axcalendar.libs.lamp.bukkit.annotation.CommandPermission;
import com.artillexstudios.axcalendar.libs.lamp.orphan.OrphanCommand;
import com.artillexstudios.axcalendar.libs.lamp.orphan.Orphans;
import com.artillexstudios.axcalendar.utils.CalendarUtils;
import com.artillexstudios.axcalendar.utils.CommandMessages;
import java.util.Locale;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class Commands
implements OrphanCommand {
    private static BukkitCommandHandler handler = null;

    @DefaultFor(value={"~", "~ open"})
    public void open(@NotNull Player sender) {
        Open.INSTANCE.execute(sender);
    }

    @Subcommand(value={"help"})
    public void help(@NotNull CommandSender sender) {
        for (String m : AxCalendar.LANG.getStringList("help")) {
            sender.sendMessage(StringUtils.formatToString(m, new TagResolver[0]));
        }
    }

    @Subcommand(value={"reload"})
    @CommandPermission(value="axcalendar.admin")
    public void reload(@NotNull CommandSender sender) {
        Reload.INSTANCE.execute(sender);
    }

    @Subcommand(value={"reset"})
    @CommandPermission(value="axcalendar.admin")
    public void reset(@NotNull CommandSender sender, OfflinePlayer player) {
        Reset.INSTANCE.execute(sender, player);
    }

    @Subcommand(value={"debuginfo"})
    @CommandPermission(value="axcalendar.admin")
    public void debuginfo(@NotNull CommandSender sender) {
        sender.sendMessage(StringUtils.formatToString("&#FF0000Current milliseconds: &f" + CalendarUtils.getZonedDateTime().toInstant().toEpochMilli(), new TagResolver[0]));
        sender.sendMessage(StringUtils.formatToString("&#FF0000Date: &f" + String.valueOf(CalendarUtils.getZonedDateTime()), new TagResolver[0]));
    }

    public static void registerCommand() {
        if (handler == null) {
            handler = BukkitCommandHandler.create((Plugin)AxCalendar.getInstance());
            handler.getTranslator().add(new CommandMessages());
            handler.setLocale(new Locale("en", "US"));
        }
        handler.unregisterAllCommands();
        handler.register(Orphans.path((String[])AxCalendar.CONFIG.getStringList("command-aliases").toArray(String[]::new)).handler(new Commands()));
        handler.registerBrigadier();
    }
}

