/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axcalendar;

import com.artillexstudios.axcalendar.commands.Commands;
import com.artillexstudios.axcalendar.database.Database;
import com.artillexstudios.axcalendar.database.impl.H2;
import com.artillexstudios.axcalendar.database.impl.MySQL;
import com.artillexstudios.axcalendar.database.impl.PostgreSQL;
import com.artillexstudios.axcalendar.database.impl.SQLite;
import com.artillexstudios.axcalendar.gui.GuiUpdater;
import com.artillexstudios.axcalendar.gui.data.MenuManager;
import com.artillexstudios.axcalendar.hooks.PlaceholderAPIParser;
import com.artillexstudios.axcalendar.hooks.Placeholders;
import com.artillexstudios.axcalendar.libraries.Libraries;
import com.artillexstudios.axcalendar.libs.axapi.AxPlugin;
import com.artillexstudios.axcalendar.libs.axapi.config.Config;
import com.artillexstudios.axcalendar.libs.axapi.dependencies.DependencyManagerWrapper;
import com.artillexstudios.axcalendar.libs.axapi.executor.ThreadedQueue;
import com.artillexstudios.axcalendar.libs.axapi.libs.boostedyaml.dvs.versioning.BasicVersioning;
import com.artillexstudios.axcalendar.libs.axapi.libs.boostedyaml.settings.dumper.DumperSettings;
import com.artillexstudios.axcalendar.libs.axapi.libs.boostedyaml.settings.general.GeneralSettings;
import com.artillexstudios.axcalendar.libs.axapi.libs.boostedyaml.settings.loader.LoaderSettings;
import com.artillexstudios.axcalendar.libs.axapi.libs.boostedyaml.settings.updater.UpdaterSettings;
import com.artillexstudios.axcalendar.libs.axapi.metrics.AxMetrics;
import com.artillexstudios.axcalendar.libs.axapi.utils.MessageUtils;
import com.artillexstudios.axcalendar.libs.axapi.utils.StringUtils;
import com.artillexstudios.axcalendar.libs.axapi.utils.featureflags.FeatureFlags;
import com.artillexstudios.axcalendar.libs.bstats.bukkit.Metrics;
import com.artillexstudios.axcalendar.utils.CalendarUtils;
import com.artillexstudios.axcalendar.utils.UpdateNotifier;
import java.io.File;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import revxrsal.zapper.DependencyManager;
import revxrsal.zapper.relocation.Relocation;

public final class AxCalendar
extends AxPlugin {
    public static Config CONFIG;
    public static Config LANG;
    public static Config MENU;
    public static Config REWARDS;
    public static MessageUtils MESSAGEUTILS;
    private static AxPlugin instance;
    private static ThreadedQueue<Runnable> threadedQueue;
    private static Database database;
    private static Placeholders placeholderParser;
    private static AxMetrics metrics;

    public static ThreadedQueue<Runnable> getThreadedQueue() {
        return threadedQueue;
    }

    public static Database getDatabase() {
        return database;
    }

    public static AxPlugin getInstance() {
        return instance;
    }

    public static Placeholders getPlaceholderParser() {
        return placeholderParser;
    }

    @Override
    public void dependencies(DependencyManagerWrapper manager) {
        instance = this;
        manager.repository("https://jitpack.io/");
        manager.repository("https://repo.codemc.org/repository/maven-public/");
        manager.repository("https://repo.papermc.io/repository/maven-public/");
        manager.repository("https://repo.artillex-studios.com/releases/");
        DependencyManager dependencyManager = manager.wrapped();
        for (Libraries lib : Libraries.values()) {
            dependencyManager.dependency(lib.fetchLibrary());
            for (Relocation relocation : lib.relocations()) {
                dependencyManager.relocate(relocation);
            }
        }
    }

    @Override
    public void enable() {
        new Metrics((Plugin)this, 20392);
        CONFIG = new Config(new File(this.getDataFolder(), "config.yml"), this.getResource("config.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setKeepAll(true).setVersioning(new BasicVersioning("version")).build());
        LANG = new Config(new File(this.getDataFolder(), "lang.yml"), this.getResource("lang.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setKeepAll(true).setVersioning(new BasicVersioning("version")).build());
        MENU = new Config(new File(this.getDataFolder(), "menu.yml"), this.getResource("menu.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().build(), DumperSettings.DEFAULT, UpdaterSettings.builder().build());
        REWARDS = new Config(new File(this.getDataFolder(), "rewards.yml"), this.getResource("rewards.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().build(), DumperSettings.DEFAULT, UpdaterSettings.builder().build());
        MESSAGEUTILS = new MessageUtils(LANG.getBackingDocument(), "prefix", CONFIG.getBackingDocument());
        threadedQueue = new ThreadedQueue("AxCalendar-Datastore-thread");
        Commands.registerCommand();
        CalendarUtils.reload();
        MenuManager.reload();
        switch (CONFIG.getString("database.type").toLowerCase()) {
            case "sqlite": {
                database = new SQLite();
                break;
            }
            case "mysql": {
                database = new MySQL();
                break;
            }
            case "postgresql": {
                database = new PostgreSQL();
                break;
            }
            default: {
                database = new H2();
            }
        }
        database.setup();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            placeholderParser = new PlaceholderAPIParser();
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF0055[AxCalendar] Hooked into PlaceholderAPI!", new TagResolver[0]));
        } else {
            placeholderParser = new Placeholders(this){};
        }
        GuiUpdater.start();
        metrics = new AxMetrics(this, 21L);
        metrics.start();
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF0055[AxCalendar] Loaded plugin! Using &f" + database.getType() + " &#FF0055database to store data!", new TagResolver[0]));
        if (CONFIG.getBoolean("update-notifier.enabled", true)) {
            new UpdateNotifier(this, 5135);
        }
    }

    @Override
    public void disable() {
        if (metrics != null) {
            metrics.cancel();
        }
        database.disable();
        GuiUpdater.stop();
    }

    @Override
    public void updateFlags() {
        FeatureFlags.USE_LEGACY_HEX_FORMATTER.set(true);
    }
}

