/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axafkzone.zones;

import com.artillexstudios.axafkzone.AxAFKZone;
import com.artillexstudios.axafkzone.libs.axapi.config.Config;
import com.artillexstudios.axafkzone.libs.axapi.libs.boostedyaml.block.implementation.Section;
import com.artillexstudios.axafkzone.libs.axapi.nms.wrapper.ServerPlayerWrapper;
import com.artillexstudios.axafkzone.libs.axapi.packet.wrapper.clientbound.ClientboundClearTitlesWrapper;
import com.artillexstudios.axafkzone.libs.axapi.serializers.Serializers;
import com.artillexstudios.axafkzone.libs.axapi.utils.ActionBar;
import com.artillexstudios.axafkzone.libs.axapi.utils.BossBar;
import com.artillexstudios.axafkzone.libs.axapi.utils.Cooldown;
import com.artillexstudios.axafkzone.libs.axapi.utils.MessageUtils;
import com.artillexstudios.axafkzone.libs.axapi.utils.StringUtils;
import com.artillexstudios.axafkzone.libs.axapi.utils.Title;
import com.artillexstudios.axafkzone.reward.Reward;
import com.artillexstudios.axafkzone.selection.Region;
import com.artillexstudios.axafkzone.utils.RandomUtils;
import com.artillexstudios.axafkzone.utils.TimeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Zone {
    private final ConcurrentHashMap<Player, Integer> zonePlayers = new ConcurrentHashMap();
    private final ConcurrentHashMap<Player, BossBar> bossbars = new ConcurrentHashMap();
    private final LinkedList<Reward> rewards = new LinkedList();
    private final Cooldown<Player> cooldown = Cooldown.createSynchronized();
    private final MessageUtils msg;
    private final String name;
    private final Config settings;
    private Region region;
    private int ticks = 0;
    private int rewardSeconds;
    private int rollAmount;

    public Zone(String name, Config settings) {
        this.name = name;
        this.settings = settings;
        this.msg = new MessageUtils(settings.getBackingDocument(), "prefix", AxAFKZone.CONFIG.getBackingDocument());
        this.reload();
    }

    public void tick() {
        boolean runChecks = ++this.ticks % 20 == 0;
        Set<Player> players = this.region.getPlayersInZone();
        Iterator<Map.Entry<Player, Integer>> it = this.zonePlayers.entrySet().iterator();
        while (it.hasNext()) {
            Player player = it.next().getKey();
            if (!player.isOnline()) {
                players.remove(player);
                this.leave(player, it);
                continue;
            }
            if (!players.contains(player)) {
                this.leave(player, it);
                continue;
            }
            if (runChecks) {
                int newTime = this.zonePlayers.get(player) + 1;
                this.zonePlayers.put(player, newTime);
                if (newTime != 0 && newTime % this.rewardSeconds == 0) {
                    this.giveRewards(player, newTime);
                    if (AxAFKZone.CONFIG.getBoolean("reset-after-reward", false)) {
                        this.zonePlayers.put(player, 0);
                    }
                }
                this.sendTitle(player);
                this.sendActionbar(player);
                this.updateBossbar(player);
            }
            players.remove(player);
        }
        int ipLimit = AxAFKZone.CONFIG.getInt("zone-per-ip-limit", -1);
        for (Player player : players) {
            if (this.cooldown.hasCooldown(player)) continue;
            if (ipLimit != -1 && this.zonePlayers.keySet().stream().filter(p1 -> p1.getAddress().getAddress().equals(player.getAddress().getAddress())).count() >= (long)ipLimit) {
                AxAFKZone.MESSAGEUTILS.sendLang((CommandSender)player, "zone.ip-limit", new TagResolver[0]);
                this.cooldown.addCooldown(player, 3000L);
                continue;
            }
            this.enter(player);
        }
    }

    private void enter(Player player) {
        BossBar bossBar = this.bossbars.remove(player);
        if (bossBar != null) {
            bossBar.remove();
        }
        this.msg.sendLang((CommandSender)player, "messages.entered", Map.of("%time%", TimeUtils.fancyTime((long)this.rewardSeconds * 1000L)));
        this.zonePlayers.put(player, 0);
        Section section = this.settings.getSection("in-zone.bossbar");
        if (section != null) {
            bossBar = BossBar.create(StringUtils.format(section.getString("name").replace("%time%", TimeUtils.fancyTime(this.timeUntilNext(player))), new TagResolver[0]), 1.0f, BossBar.Color.valueOf(section.getString("color").toUpperCase()), BossBar.Style.parse(section.getString("style")));
            bossBar.show(player);
            this.bossbars.put(player, bossBar);
        }
        this.sendTitle(player);
        this.sendActionbar(player);
    }

    private void leave(Player player, Iterator<Map.Entry<Player, Integer>> it) {
        if (player.isOnline()) {
            this.msg.sendLang((CommandSender)player, "messages.left", Map.of("%time%", TimeUtils.fancyTime((long)this.zonePlayers.get(player).intValue() * 1000L)));
        }
        it.remove();
        BossBar bossBar = this.bossbars.remove(player);
        if (bossBar != null) {
            bossBar.remove();
        }
        this.removeTitle(player);
    }

    private void sendTitle(Player player) {
        String zoneTitle = this.settings.getString("in-zone.title", null);
        String zoneSubTitle = this.settings.getString("in-zone.subtitle", null);
        if (zoneTitle != null && !zoneTitle.isBlank() || zoneSubTitle != null && !zoneSubTitle.isBlank()) {
            Title title = Title.create((Component)(zoneTitle == null ? Component.empty() : StringUtils.format(zoneTitle.replace("%time%", TimeUtils.fancyTime(this.timeUntilNext(player))), new TagResolver[0])), (Component)(zoneSubTitle == null ? Component.empty() : StringUtils.format(zoneSubTitle.replace("%time%", TimeUtils.fancyTime(this.timeUntilNext(player))), new TagResolver[0])), 0, 25, 0);
            title.send(player);
        }
    }

    private void removeTitle(Player player) {
        ServerPlayerWrapper wrapper = ServerPlayerWrapper.wrap(player);
        wrapper.sendPacket(new ClientboundClearTitlesWrapper(true));
    }

    private void sendActionbar(Player player) {
        String zoneActionbar = this.settings.getString("in-zone.actionbar", null);
        if (zoneActionbar != null && !zoneActionbar.isBlank()) {
            ActionBar.send(player, StringUtils.format(zoneActionbar.replace("%time%", TimeUtils.fancyTime(this.timeUntilNext(player))), new TagResolver[0]));
        }
    }

    private void updateBossbar(Player player) {
        BossBar bossBar = this.bossbars.get(player);
        if (bossBar == null) {
            return;
        }
        Integer time = this.zonePlayers.get(player);
        if (time == null) {
            return;
        }
        int barDirection = AxAFKZone.CONFIG.getInt("bossbar-direction", 0);
        float calculated = (float)(time % this.rewardSeconds) / (float)(this.rewardSeconds - 1);
        bossBar.progress(Math.max(0.0f, Math.min(1.0f, barDirection == 0 ? 1.0f - calculated : calculated)));
        Section section = this.settings.getSection("in-zone.bossbar");
        if (section != null) {
            bossBar.title(StringUtils.format(section.getString("name").replace("%time%", TimeUtils.fancyTime(this.timeUntilNext(player))), new TagResolver[0]));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void giveRewards(Player player, int newTime) {
        List<Reward> rewardList = this.rollAndGiveRewards(player);
        if (this.settings.getStringList("messages.reward").isEmpty()) {
            return;
        }
        String prefix = AxAFKZone.CONFIG.getString("prefix");
        boolean first = true;
        for (String string : this.settings.getStringList("messages.reward")) {
            void var7_7;
            if (first) {
                String string2 = prefix + string;
                first = false;
            }
            if (var7_7.contains("%reward%")) {
                for (Reward reward : rewardList) {
                    player.sendMessage(StringUtils.formatToString((String)var7_7, Map.of("%reward%", Optional.ofNullable(reward.getDisplay()).orElse("---"), "%time%", TimeUtils.fancyTime((long)newTime * 1000L))));
                }
                continue;
            }
            player.sendMessage(StringUtils.formatToString((String)var7_7, Map.of("%time%", TimeUtils.fancyTime((long)newTime * 1000L))));
        }
    }

    public long timeUntilNext(Player player) {
        Integer time = this.zonePlayers.get(player);
        if (time == null) {
            return -1L;
        }
        return (long)this.rewardSeconds * 1000L - (long)(time % this.rewardSeconds) * 1000L;
    }

    public List<Reward> rollAndGiveRewards(Player player) {
        ArrayList<Reward> rewardList = new ArrayList<Reward>();
        if (this.rewards.isEmpty()) {
            return rewardList;
        }
        HashMap<Reward, Double> chances = new HashMap<Reward, Double>();
        for (Reward reward : this.rewards) {
            chances.put(reward, reward.getChance());
        }
        for (int i = 0; i < this.rollAmount; ++i) {
            Reward sel = RandomUtils.randomValue(chances);
            rewardList.add(sel);
            sel.run(player);
        }
        return rewardList;
    }

    public boolean reload() {
        if (!this.settings.reload()) {
            return false;
        }
        this.region = new Region(Serializers.LOCATION.deserialize(this.settings.getString("zone.location1")), Serializers.LOCATION.deserialize(this.settings.getString("zone.location2")), this);
        this.rewardSeconds = this.settings.getInt("reward-time-seconds", 180);
        this.rollAmount = this.settings.getInt("roll-amount", 1);
        this.rewards.clear();
        for (Map<Object, Object> map : this.settings.getMapList("rewards")) {
            Reward reward = new Reward(map);
            this.rewards.add(reward);
        }
        return true;
    }

    public void disable() {
        for (BossBar bossBar : this.bossbars.values()) {
            bossBar.remove();
        }
    }

    public void setRegion(Region region) {
        this.region = region;
        this.settings.set("zone.location1", Serializers.LOCATION.serialize(region.getCorner1()));
        this.settings.set("zone.location2", Serializers.LOCATION.serialize(region.getCorner2()));
        this.settings.save();
    }

    public String getName() {
        return this.name;
    }

    public Config getSettings() {
        return this.settings;
    }

    public Region getRegion() {
        return this.region;
    }

    public int getTicks() {
        return this.ticks;
    }
}

