/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axafkzone.libs.axapi.placeholders;

import com.artillexstudios.axafkzone.libs.axapi.placeholders.DefaultPlaceholderFormatter;
import com.artillexstudios.axafkzone.libs.axapi.placeholders.Placeholder;
import com.artillexstudios.axafkzone.libs.axapi.placeholders.PlaceholderArgument;
import com.artillexstudios.axafkzone.libs.axapi.placeholders.PlaceholderArguments;
import com.artillexstudios.axafkzone.libs.axapi.placeholders.PlaceholderContext;
import com.artillexstudios.axafkzone.libs.axapi.placeholders.PlaceholderFormatter;
import com.artillexstudios.axafkzone.libs.axapi.placeholders.PlaceholderParameters;
import com.artillexstudios.axafkzone.libs.axapi.placeholders.PlaceholderTransformer;
import com.artillexstudios.axafkzone.libs.axapi.placeholders.exception.PlaceholderException;
import com.artillexstudios.axafkzone.libs.axapi.placeholders.exception.PlaceholderParameterNotInContextException;
import com.artillexstudios.axafkzone.libs.axapi.reflection.ClassUtils;
import com.artillexstudios.axafkzone.libs.axapi.utils.Optionals;
import com.artillexstudios.axafkzone.libs.axapi.utils.featureflags.FeatureFlags;
import com.artillexstudios.axafkzone.libs.axapi.utils.functions.ThrowingFunction;
import com.artillexstudios.axafkzone.libs.axapi.utils.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.regex.Matcher;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class PlaceholderHandler {
    private static final List<Placeholder> placeholders = new ArrayList<Placeholder>();
    private static final ConcurrentLinkedQueue<PlaceholderTransformer<Object, Object>> transformers = new ConcurrentLinkedQueue();
    private static Placeholder[] baked = new Placeholder[0];

    void test() {
        PlaceholderHandler.register("wins_<koth>", new PlaceholderArguments(new PlaceholderArgument("koth", null)), (PlaceholderContext ctx) -> {
            Object koth = ctx.argument("koth");
            return koth.toString();
        });
    }

    public static <T, Z> void registerTransformer(Class<T> fromClazz, Class<Z> toClazz, Function<T, Z> transformer) {
        transformers.add(new PlaceholderTransformer<T, Z>(fromClazz, toClazz, transformer));
    }

    public static void register(String placeholder, ThrowingFunction<PlaceholderContext, String, PlaceholderException> handler) {
        PlaceholderHandler.register(placeholder, new PlaceholderArguments(new PlaceholderArgument[0]), handler, false);
    }

    public static void register(String placeholder, ThrowingFunction<PlaceholderContext, String, PlaceholderException> handler, boolean placeholderAPI) {
        PlaceholderHandler.register(placeholder, new PlaceholderArguments(new PlaceholderArgument[0]), handler, placeholderAPI);
    }

    public static void register(String placeholder, ThrowingFunction<PlaceholderContext, String, PlaceholderException> handler, PlaceholderFormatter formatter) {
        PlaceholderHandler.register(placeholder, new PlaceholderArguments(new PlaceholderArgument[0]), handler, formatter, false);
    }

    public static void register(String placeholder, ThrowingFunction<PlaceholderContext, String, PlaceholderException> handler, PlaceholderFormatter formatter, boolean placeholderAPI) {
        PlaceholderHandler.register(placeholder, new PlaceholderArguments(new PlaceholderArgument[0]), handler, formatter, placeholderAPI);
    }

    public static void register(String placeholder, PlaceholderArguments arguments, ThrowingFunction<PlaceholderContext, String, PlaceholderException> handler) {
        PlaceholderHandler.register(placeholder, arguments, handler, DefaultPlaceholderFormatter.INSTANCE, false);
    }

    public static void register(String placeholder, PlaceholderArguments arguments, ThrowingFunction<PlaceholderContext, String, PlaceholderException> handler, boolean placeholderAPI) {
        PlaceholderHandler.register(placeholder, arguments, handler, DefaultPlaceholderFormatter.INSTANCE, placeholderAPI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(String placeholder, PlaceholderArguments arguments, ThrowingFunction<PlaceholderContext, String, PlaceholderException> handler, PlaceholderFormatter formatter, boolean placeholderAPI) {
        List<String> formatted = formatter.format(placeholder);
        List<Placeholder> list = placeholders;
        synchronized (list) {
            for (String string : formatted) {
                placeholders.add(new Placeholder(string, arguments, placeholderAPI, handler));
            }
            placeholders.sort(Comparator.comparing(Placeholder::placeholder).reversed());
            baked = placeholders.toArray(new Placeholder[0]);
        }
    }

    public static String parse(String line) {
        return PlaceholderHandler.parse(line, null);
    }

    public static <T> String parse(String line, Class<T> clazz, T value) {
        return PlaceholderHandler.parse(line, new PlaceholderParameters().withParameter(clazz, value));
    }

    public static String parse(String line, Object ... objects) {
        return PlaceholderHandler.parse(line, new PlaceholderParameters().withParameters(objects));
    }

    public static String parseWithPlaceholderAPI(String line, PlaceholderParameters parameters) {
        String newLine = PlaceholderHandler.parse(line, parameters);
        if (ClassUtils.INSTANCE.classExists("me.clip.placeholderapi.PlaceholderAPI")) {
            try {
                newLine = PlaceholderAPI.setPlaceholders((Player)Optionals.orElse((Player)parameters.getByName("player"), parameters.resolve(Player.class)), (String)newLine);
            }
            catch (PlaceholderParameterNotInContextException exception) {
                return newLine;
            }
        }
        return newLine;
    }

    public static String parse(String line, PlaceholderParameters parameters) {
        for (Placeholder placeholder : baked) {
            if (placeholder.arguments().arguments().length == 0) {
                if (!line.contains(placeholder.placeholder())) continue;
                try {
                    line = line.replace(placeholder.placeholder(), placeholder.handler().apply(placeholder.newContext(parameters, null)));
                }
                catch (PlaceholderException exception) {
                    if (!((Boolean)FeatureFlags.DEBUG.get()).booleanValue()) continue;
                    LogUtils.warn("Placeholder parse! Line: {}", line, exception);
                }
                continue;
            }
            line = PlaceholderHandler.parseInternal(placeholder, line, parameters);
        }
        return line;
    }

    private static String parseInternal(Placeholder placeholder, String line, PlaceholderParameters parameters) {
        StringBuilder builder = new StringBuilder(line.length());
        Matcher match = placeholder.match(line);
        while (match.find()) {
            String apply;
            try {
                apply = placeholder.handler().apply(placeholder.newContext(parameters, match));
            }
            catch (PlaceholderException exception) {
                if (!((Boolean)FeatureFlags.DEBUG.get()).booleanValue()) continue;
                LogUtils.warn("Placeholder parse! Line: {}", line, exception);
                continue;
            }
            match.appendReplacement(builder, apply);
        }
        match.appendTail(builder);
        return builder.toString();
    }

    public static Map<String, String> mapped(Object ... objects) {
        return PlaceholderHandler.mapped(new PlaceholderParameters().withParameters(objects));
    }

    public static Map<String, String> mapped(PlaceholderParameters parameters) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Placeholder placeholder : baked) {
            String parsed;
            if (placeholder.arguments().arguments().length != 0 || (parsed = PlaceholderHandler.parse(placeholder.placeholder(), parameters)).equals(placeholder.placeholder())) continue;
            map.put(placeholder.placeholder(), parsed);
        }
        return map;
    }

    public static List<String> placeholders() {
        return PlaceholderHandler.placeholders(null, false);
    }

    public static List<String> placeholders(String prefix) {
        return PlaceholderHandler.placeholders(prefix, true);
    }

    public static List<String> placeholders(String prefix, boolean placeholderAPI) {
        return Arrays.stream(baked).filter(placeholder -> placeholder.placeholderAPI() == placeholderAPI).map(placeholder -> {
            if (prefix == null) {
                return placeholder.placeholder();
            }
            return "%" + prefix + "_" + placeholder.placeholder().replace("%", "") + "%";
        }).toList();
    }

    public static ConcurrentLinkedQueue<PlaceholderTransformer<Object, Object>> transformers() {
        return transformers;
    }

    static {
        PlaceholderHandler.registerTransformer(Player.class, OfflinePlayer.class, player -> player);
        PlaceholderHandler.registerTransformer(OfflinePlayer.class, Player.class, OfflinePlayer::getPlayer);
    }
}

