/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axafkzone.libs.axapi.nms.v1_21_R5;

import com.artillexstudios.axafkzone.libs.axapi.utils.logging.LogUtils;
import com.google.common.base.Preconditions;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.SnbtPrinterTagVisitor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public enum ItemStackSerializer {
    INSTANCE;


    public byte[] serializeAsBytes(ItemStack itemStack) {
        byte[] byArray;
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"Can't serialise a null itemstack!");
        Preconditions.checkArgument((itemStack.getType() != Material.AIR ? 1 : 0) != 0, (Object)"Can't serialise air!");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            NBTTagCompound compoundTag = (NBTTagCompound)net.minecraft.world.item.ItemStack.b.encodeStart((DynamicOps)MinecraftServer.getServer().ba().a((DynamicOps)DynamicOpsNBT.a), (Object)CraftItemStack.asNMSCopy((ItemStack)itemStack)).getOrThrow();
            compoundTag.a("DataVersion", SharedConstants.b().a().b());
            NBTCompressedStreamTools.a((NBTTagCompound)compoundTag, (OutputStream)outputStream);
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        outputStream.close();
        return byArray;
    }

    public ItemStack deserializeFromBytes(byte[] bytes) {
        CraftItemStack craftItemStack;
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        try {
            NBTTagCompound compound = NBTCompressedStreamTools.a((InputStream)stream, (NBTReadLimiter)NBTReadLimiter.a());
            int dataVersion = compound.b("DataVersion", 0);
            NBTTagCompound converted = (NBTTagCompound)MinecraftServer.getServer().L.update(DataConverterTypes.u, new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)compound), dataVersion, SharedConstants.b().a().b()).getValue();
            net.minecraft.world.item.ItemStack minecraftStack = (net.minecraft.world.item.ItemStack)net.minecraft.world.item.ItemStack.b.parse((DynamicOps)MinecraftServer.getServer().ba().a((DynamicOps)DynamicOpsNBT.a), (Object)converted).getOrThrow();
            craftItemStack = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)minecraftStack);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        stream.close();
        return craftItemStack;
    }

    public String serializeAsSnbt(ItemStack itemStack) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"Can't serialise a null itemstack!");
        Preconditions.checkArgument((itemStack.getType() != Material.AIR ? 1 : 0) != 0, (Object)"Can't serialise air!");
        NBTTagCompound compoundTag = (NBTTagCompound)net.minecraft.world.item.ItemStack.b.encodeStart((DynamicOps)MinecraftServer.getServer().ba().a((DynamicOps)DynamicOpsNBT.a), (Object)CraftItemStack.asNMSCopy((ItemStack)itemStack)).getOrThrow();
        compoundTag.a("DataVersion", SharedConstants.b().a().b());
        return new SnbtPrinterTagVisitor().a((NBTBase)compoundTag);
    }

    public ItemStack deserializeFromSnbt(String snbt) {
        try {
            NBTTagCompound parsed = MojangsonParser.a((String)snbt);
            int dataVersion = parsed.b("DataVersion", 0);
            NBTTagCompound converted = (NBTTagCompound)MinecraftServer.getServer().L.update(DataConverterTypes.u, new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)parsed), dataVersion, SharedConstants.b().a().b()).getValue();
            net.minecraft.world.item.ItemStack minecraftStack = (net.minecraft.world.item.ItemStack)net.minecraft.world.item.ItemStack.b.parse((DynamicOps)MinecraftServer.getServer().ba().a((DynamicOps)DynamicOpsNBT.a), (Object)converted).getOrThrow();
            return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)minecraftStack);
        }
        catch (CommandSyntaxException exception) {
            LogUtils.error("Failed to parse SNBT into an ItemStack! Please, check out the exception for more details!", new Object[]{exception});
            throw new RuntimeException(exception);
        }
    }
}

