/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axafkzone.libs.axapi.context;

import com.artillexstudios.axafkzone.libs.axapi.context.ContextKey;
import com.artillexstudios.axafkzone.libs.axapi.utils.UncheckedUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class HashMapContext {
    protected final HashMap<ContextKey<?>, Object> values;

    public HashMapContext() {
        this(new HashMap(1));
    }

    public HashMapContext(HashMapContext context) {
        this(new HashMap(context.values));
    }

    public HashMapContext(HashMap<ContextKey<?>, Object> contents) {
        this.values = contents;
    }

    public static HashMapContext create() {
        return new HashMapContext();
    }

    public <T> HashMapContext with(ContextKey<T> key, T value) {
        this.values.put(key, value);
        return this;
    }

    public <T> T getByClass(Class<T> clazz) {
        for (Map.Entry<ContextKey<?>, Object> entry : this.values.entrySet()) {
            if (!entry.getKey().type().equals(clazz)) continue;
            return clazz.cast(entry.getValue());
        }
        return null;
    }

    public <T> T getByName(String name) {
        for (Map.Entry<ContextKey<?>, Object> entry : this.values.entrySet()) {
            if (!entry.getKey().name().equals(name)) continue;
            return UncheckedUtils.unsafeCast(entry.getValue());
        }
        return null;
    }

    public <T> T get(ContextKey<T> key) {
        return key.type().cast(this.values.get(key));
    }

    public HashMapContext copy() {
        return new HashMapContext(this);
    }

    public HashMapContext merge(HashMapContext other) {
        for (Map.Entry<ContextKey<?>, Object> entry : other.values.entrySet()) {
            if (this.values.containsKey(entry.getKey())) continue;
            this.values.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof HashMapContext)) {
            return false;
        }
        HashMapContext context = (HashMapContext)object;
        return Objects.equals(this.values, context.values);
    }

    public int hashCode() {
        return Objects.hashCode(this.values);
    }
}

