/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.util;

import dev.aurelium.auraskills.slate.util.VersionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.Nullable;

public class InventoryUtil {
    private static Method getOpenInventoryMethod;
    private static Method getTopInventoryMethod;
    private static Method getBottomInventoryMethod;
    private static boolean reflectionInitialized;
    private static boolean reflectionFailed;

    @Nullable
    public static Inventory getTopInventory(Player player) {
        if (VersionUtil.isAtLeastVersion(21)) {
            return player.getOpenInventory().getTopInventory();
        }
        if (reflectionFailed) {
            return null;
        }
        try {
            InventoryUtil.initReflection(player);
            return InventoryUtil.invokeInventory(player, getTopInventoryMethod);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            reflectionFailed = true;
            return null;
        }
    }

    @Nullable
    public static Inventory getBottomInventory(Player player) {
        if (VersionUtil.isAtLeastVersion(21)) {
            return player.getOpenInventory().getBottomInventory();
        }
        if (reflectionFailed) {
            return null;
        }
        try {
            InventoryUtil.initReflection(player);
            return InventoryUtil.invokeInventory(player, getBottomInventoryMethod);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            reflectionFailed = true;
            return null;
        }
    }

    private static Inventory invokeInventory(Player player, Method method) throws IllegalAccessException, InvocationTargetException {
        Object inventoryView = getOpenInventoryMethod.invoke((Object)player, new Object[0]);
        Object inventory = method.invoke(inventoryView, new Object[0]);
        if (inventory instanceof Inventory) {
            return (Inventory)inventory;
        }
        return null;
    }

    private static void initReflection(Player player) throws IllegalAccessException, InvocationTargetException {
        if (reflectionInitialized) {
            return;
        }
        try {
            getOpenInventoryMethod = Player.class.getMethod("getOpenInventory", new Class[0]);
            Object inventoryView = getOpenInventoryMethod.invoke((Object)player, new Object[0]);
            if (inventoryView == null) {
                reflectionFailed = true;
                return;
            }
            getTopInventoryMethod = inventoryView.getClass().getMethod("getTopInventory", new Class[0]);
            getTopInventoryMethod.setAccessible(true);
            getBottomInventoryMethod = inventoryView.getClass().getMethod("getBottomInventory", new Class[0]);
            getBottomInventoryMethod.setAccessible(true);
            reflectionInitialized = true;
        }
        catch (NoSuchMethodException e) {
            reflectionFailed = true;
        }
    }

    static {
        reflectionInitialized = false;
        reflectionFailed = false;
    }
}

