/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.text;

import dev.aurelium.auraskills.slate.Slate;
import dev.aurelium.auraskills.slate.function.TemplateReplacer;
import dev.aurelium.auraskills.slate.info.TemplatePlaceholderInfo;
import dev.aurelium.auraskills.slate.item.provider.PlaceholderData;
import dev.aurelium.auraskills.slate.item.provider.PlaceholderType;
import dev.aurelium.auraskills.slate.lore.ListData;
import dev.aurelium.auraskills.slate.lore.LoreInterpreter;
import dev.aurelium.auraskills.slate.menu.ActiveMenu;
import dev.aurelium.auraskills.slate.util.LoreUtil;
import dev.aurelium.auraskills.slate.util.Pair;
import dev.aurelium.auraskills.slate.util.TextUtil;
import java.util.Map;
import org.bukkit.entity.Player;

public class TemplateTextReplacer<T> {
    private final Slate slate;
    private final Map<String, TemplateReplacer<T>> replacers;
    private final TemplateReplacer<T> anyReplacer;

    public TemplateTextReplacer(Slate slate, Map<String, TemplateReplacer<T>> replacers, TemplateReplacer<T> anyReplacer) {
        this.slate = slate;
        this.replacers = replacers;
        this.anyReplacer = anyReplacer;
    }

    public String applyReplacers(String input, Player player, ActiveMenu activeMenu, PlaceholderType type, T value) {
        input = this.slate.getGlobalBehavior().applyGlobalReplacers(input, this.slate, player, activeMenu, type);
        String[] placeholders = TextUtil.substringsBetween(input, "{", "}");
        if (placeholders != null) {
            String style = LoreUtil.getStyle(input);
            for (String placeholder : placeholders) {
                Pair<String, ListData> pair = LoreInterpreter.detectListPlaceholder(placeholder);
                PlaceholderData data = new PlaceholderData(type, style, pair.second());
                String coreName = pair.first();
                TemplatePlaceholderInfo<T> info = new TemplatePlaceholderInfo<T>(this.slate, player, coreName, activeMenu, data, value);
                for (Map.Entry<String, TemplateReplacer<T>> entry : this.replacers.entrySet()) {
                    String replaced;
                    if (!entry.getKey().equals(coreName) || (replaced = entry.getValue().replace(info)) == null) continue;
                    input = TextUtil.replace(input, "{" + placeholder + "}", replaced);
                }
                String replaced = this.anyReplacer.replace(info);
                if (replaced == null) continue;
                input = TextUtil.replace(input, "{" + placeholder + "}", replaced);
            }
        }
        return input;
    }
}

