/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.menu;

import dev.aurelium.auraskills.kyori.adventure.text.Component;
import dev.aurelium.auraskills.slate.Slate;
import dev.aurelium.auraskills.slate.action.Action;
import dev.aurelium.auraskills.slate.action.ItemActions;
import dev.aurelium.auraskills.slate.action.trigger.ClickTrigger;
import dev.aurelium.auraskills.slate.action.trigger.MenuTrigger;
import dev.aurelium.auraskills.slate.builder.BuiltItem;
import dev.aurelium.auraskills.slate.builder.BuiltMenu;
import dev.aurelium.auraskills.slate.builder.BuiltTemplate;
import dev.aurelium.auraskills.slate.fill.FillData;
import dev.aurelium.auraskills.slate.info.ItemInfo;
import dev.aurelium.auraskills.slate.info.MenuInfo;
import dev.aurelium.auraskills.slate.info.TemplateInfo;
import dev.aurelium.auraskills.slate.inv.ClickableItem;
import dev.aurelium.auraskills.slate.inv.ItemClickData;
import dev.aurelium.auraskills.slate.inv.content.InventoryContents;
import dev.aurelium.auraskills.slate.inv.content.InventoryProvider;
import dev.aurelium.auraskills.slate.inv.content.SlotPos;
import dev.aurelium.auraskills.slate.item.ItemClick;
import dev.aurelium.auraskills.slate.item.ItemVariant;
import dev.aurelium.auraskills.slate.item.MenuItem;
import dev.aurelium.auraskills.slate.item.SingleItem;
import dev.aurelium.auraskills.slate.item.TemplateClick;
import dev.aurelium.auraskills.slate.item.TemplateItem;
import dev.aurelium.auraskills.slate.item.TemplateVariant;
import dev.aurelium.auraskills.slate.item.active.ActiveItem;
import dev.aurelium.auraskills.slate.item.active.ActiveSingleItem;
import dev.aurelium.auraskills.slate.item.active.ActiveTemplateItem;
import dev.aurelium.auraskills.slate.item.provider.PlaceholderType;
import dev.aurelium.auraskills.slate.lore.LoreInterpreter;
import dev.aurelium.auraskills.slate.lore.LoreLine;
import dev.aurelium.auraskills.slate.menu.ActiveMenu;
import dev.aurelium.auraskills.slate.menu.LoadedMenu;
import dev.aurelium.auraskills.slate.position.PositionProvider;
import dev.aurelium.auraskills.slate.text.TextFormatter;
import dev.aurelium.auraskills.slate.util.PaperUtil;
import dev.aurelium.auraskills.slate.util.TextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class MenuInventory
implements InventoryProvider {
    private final Slate slate;
    private final LoreInterpreter loreInterpreter;
    private final LoadedMenu menu;
    private final ActiveMenu activeMenu;
    private final Map<String, ActiveItem> activeItems;
    private final Map<String, Object> properties;
    private final int totalPages;
    private final int currentPage;
    private final Player player;
    private InventoryContents contents;
    private final TextFormatter tf = new TextFormatter();
    private final BuiltMenu builtMenu;
    private final ArrayList<ActiveItem> toUpdate;
    private final MenuInfo menuInfo;

    public MenuInventory(Slate slate, LoadedMenu menu, Player player, Map<String, Object> properties, int currentPage) {
        this.slate = slate;
        this.loreInterpreter = new LoreInterpreter(slate);
        this.menu = menu;
        this.activeItems = new LinkedHashMap<String, ActiveItem>();
        this.activeMenu = new ActiveMenu(this);
        this.toUpdate = new ArrayList();
        this.properties = new HashMap<String, Object>(properties);
        this.player = player;
        this.builtMenu = slate.getBuiltMenu(menu.name());
        this.totalPages = this.builtMenu.pageProvider().getPages(new MenuInfo(slate, player, this.activeMenu));
        this.currentPage = currentPage;
        this.menuInfo = new MenuInfo(slate, player, this.activeMenu);
    }

    public Slate getSlate() {
        return this.slate;
    }

    public LoadedMenu getMenu() {
        return this.menu;
    }

    public BuiltMenu getBuiltMenu() {
        return this.builtMenu;
    }

    public ActiveMenu getActiveMenu() {
        return this.activeMenu;
    }

    @Nullable
    public ActiveItem getActiveItem(String itemName) {
        return this.activeItems.get(itemName);
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public LoreInterpreter getLoreInterpreter() {
        return this.loreInterpreter;
    }

    public TextFormatter getTextFormatter() {
        return this.tf;
    }

    public void setToUpdate(ActiveItem activeItem) {
        if (!this.toUpdate.contains(activeItem)) {
            this.toUpdate.add(activeItem);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init(Player player, InventoryContents contents) {
        this.contents = contents;
        for (MenuItem menuItem : this.menu.items().values()) {
            void var5_9;
            ActiveItem activeItem = this.activeItems.get(menuItem.getName());
            if (activeItem != null && activeItem.isHidden()) continue;
            if (menuItem instanceof SingleItem) {
                ActiveSingleItem activeSingleItem = new ActiveSingleItem((SingleItem)menuItem);
            } else {
                if (!(menuItem instanceof TemplateItem)) continue;
                TemplateItem templateItem = (TemplateItem)menuItem;
                ActiveTemplateItem activeTemplateItem = new ActiveTemplateItem(templateItem);
            }
            this.activeItems.put(menuItem.getName(), (ActiveItem)var5_9);
        }
        this.builtMenu.openListener().handle(new MenuInfo(this.slate, player, this.activeMenu));
        this.menu.executeActions(MenuTrigger.OPEN, player, this);
        FillData fillData = this.menu.fillData();
        if (fillData.enabled()) {
            fillData.placeInMenu(this.slate, player, this);
        }
        for (ActiveItem activeItem : this.activeItems.values()) {
            if (activeItem instanceof ActiveSingleItem) {
                this.addSingleItem((ActiveSingleItem)activeItem, contents, player);
                continue;
            }
            if (!(activeItem instanceof ActiveTemplateItem)) continue;
            this.addTemplateItem((ActiveTemplateItem)activeItem, contents, player);
        }
    }

    @Override
    public void update(Player player, InventoryContents contents) {
        for (ActiveItem activeItem : this.toUpdate) {
            int cooldown = activeItem.getCooldown();
            if (cooldown <= 0) continue;
            activeItem.setCooldown(cooldown - 1);
        }
        this.builtMenu.updateListener().handle(this.menuInfo);
    }

    public void close(InventoryCloseEvent event) {
        this.menu.executeActions(MenuTrigger.CLOSE, this.player, this);
    }

    private void addSingleItem(ActiveSingleItem activeItem, InventoryContents contents, Player player) {
        SingleItem item = activeItem.getItem();
        ItemVariant variant = this.getItemVariant(item, this.activeMenu);
        if (item.failsViewConditions(player, this)) {
            return;
        }
        BuiltItem builtItem = this.slate.getBuiltMenu(this.menu.name()).getBackingItem(item.getName());
        ItemStack itemStack = item.getBaseItem().clone();
        if (variant != null && variant.baseItem() != null) {
            itemStack = variant.baseItem();
        }
        builtItem.initListener().handle(new MenuInfo(this.slate, player, this.activeMenu));
        this.replaceItemPlaceholders(itemStack);
        itemStack = builtItem.modifier().modify(new ItemInfo(this.slate, player, this.activeMenu, itemStack));
        if (itemStack == null) {
            return;
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta != null) {
            String displayName = item.getDisplayName();
            if (variant != null && variant.displayName() != null) {
                displayName = variant.displayName();
            }
            if (displayName != null) {
                displayName = builtItem.applyReplacers(displayName, this.slate, player, this.activeMenu, PlaceholderType.DISPLAY_NAME);
                if (this.slate.isPlaceholderAPIEnabled()) {
                    displayName = PlaceholderAPI.setPlaceholders((Player)player, (String)displayName);
                }
                this.setDisplayName(meta, this.tf.toComponent(displayName));
            }
            List<LoreLine> loreLines = item.getLore();
            if (variant != null && !variant.lore().isEmpty()) {
                loreLines = variant.lore();
            }
            if (loreLines != null) {
                this.setLore(meta, this.loreInterpreter.interpretLore(loreLines, player, this.activeMenu, builtItem, item));
            }
            itemStack.setItemMeta(meta);
        }
        List<SlotPos> positions = item.getPositions();
        if (variant != null && variant.positions() != null) {
            positions = variant.positions();
        }
        this.addSingleItemToInventory(item, itemStack, positions, contents, player, builtItem);
    }

    private <C> void addTemplateItem(ActiveTemplateItem<C> activeItem, InventoryContents contents, Player player) {
        TemplateItem item = activeItem.getItem();
        BuiltTemplate<C> builtTemplate = this.slate.getBuiltMenu(this.menu.name()).getTemplate(item.getName(), item.getContextClass());
        if (item.failsViewConditions(player, this)) {
            return;
        }
        builtTemplate.initListener().handle(new MenuInfo(this.slate, player, this.activeMenu));
        Set<C> builtDefined = builtTemplate.definedContexts().get(new MenuInfo(this.slate, player, this.activeMenu));
        Set contexts = Objects.requireNonNullElseGet(builtDefined, () -> item.getBaseItems().keySet());
        for (Object context : contexts) {
            if (item.failsContextViewConditions(context, player, this)) continue;
            this.addContextItem(contents, player, context, item, builtTemplate, contexts);
        }
    }

    @Nullable
    private ItemVariant getItemVariant(SingleItem item, ActiveMenu menu) {
        for (ItemVariant variant : item.getVariants()) {
            if (!variant.propertyFilters().isEmpty() && this.failsPropertyFilters(variant.propertyFilters(), menu)) continue;
            return variant;
        }
        return null;
    }

    @Nullable
    private <C> TemplateVariant<C> getTemplateVariant(TemplateItem<C> item, C context, ActiveMenu menu) {
        for (TemplateVariant<C> variant : item.getVariants()) {
            if (!variant.contextFilters().isEmpty() && !variant.contextFilters().contains(context) || !variant.propertyFilters().isEmpty() && this.failsPropertyFilters(variant.propertyFilters(), menu)) continue;
            return variant;
        }
        return null;
    }

    private boolean failsPropertyFilters(Map<String, Object> propertyFilters, ActiveMenu menu) {
        boolean fails = false;
        for (Map.Entry<String, Object> entry : propertyFilters.entrySet()) {
            Object propValue = menu.getProperties().get(entry.getKey());
            if (propValue == null) {
                fails = true;
                break;
            }
            if (propValue.equals(entry.getValue())) continue;
            fails = true;
            break;
        }
        return fails;
    }

    private <C> void addContextItem(InventoryContents contents, Player player, C context, TemplateItem<C> item, BuiltTemplate<C> builtTemplate, Set<C> contexts) {
        PositionProvider def;
        TemplateVariant<C> variant = this.getTemplateVariant(item, context, this.activeMenu);
        ItemStack itemStack = item.getBaseItems().get(context);
        if (itemStack == null) {
            itemStack = item.getDefaultBaseItem();
        }
        if (variant != null && variant.baseItem() != null) {
            itemStack = variant.baseItem();
        }
        if (itemStack != null) {
            itemStack = itemStack.clone();
        }
        builtTemplate.contextListener().handle(new TemplateInfo<C>(this.slate, player, this.activeMenu, itemStack, context));
        this.replaceItemPlaceholders(itemStack);
        itemStack = builtTemplate.modifier().modify(new TemplateInfo<C>(this.slate, player, this.activeMenu, itemStack, context));
        if (itemStack == null) {
            return;
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta != null) {
            this.setContextMeta(player, context, item, builtTemplate, meta, itemStack, variant);
        }
        PositionProvider posProvider = item.getPosition(context);
        if (variant != null && variant.position() != null) {
            posProvider = variant.position();
        }
        List<SlotPos> pos = null;
        if (posProvider != null) {
            ArrayList<PositionProvider> providers = new ArrayList<PositionProvider>();
            for (C cont : contexts) {
                providers.add(item.getPosition(cont));
            }
            pos = posProvider.getPosition(providers);
        } else {
            @Nullable SlotPos builtSlot = builtTemplate.slotProvider().get(new TemplateInfo<C>(this.slate, player, this.activeMenu, itemStack, context));
            if (builtSlot != null) {
                pos = List.of(builtSlot);
            }
        }
        if (pos == null && (def = item.getDefaultPosition()) != null) {
            ArrayList<PositionProvider> providers = new ArrayList<PositionProvider>();
            for (C cont : contexts) {
                providers.add(item.getPosition(cont));
            }
            pos = def.getPosition(providers);
        }
        if (pos != null) {
            this.addTemplateItemToInventory(item, itemStack, pos, contents, player, builtTemplate, context);
        }
    }

    private <C> void setContextMeta(Player player, C context, TemplateItem<C> item, BuiltTemplate<C> builtTemplate, ItemMeta meta, ItemStack itemStack, @Nullable TemplateVariant<C> variant) {
        String displayName = item.getActiveDisplayName(context);
        if (variant != null && variant.displayName() != null) {
            displayName = variant.displayName();
        }
        if (displayName != null) {
            displayName = builtTemplate.applyReplacers(displayName, this.slate, player, this.activeMenu, PlaceholderType.DISPLAY_NAME, context);
            if (this.slate.isPlaceholderAPIEnabled()) {
                displayName = PlaceholderAPI.setPlaceholders((Player)player, (String)displayName);
            }
            this.setDisplayName(meta, this.tf.toComponent(displayName));
        }
        List<LoreLine> loreLines = item.getActiveLore(context);
        if (variant != null && !variant.lore().isEmpty()) {
            loreLines = variant.lore();
        }
        if (loreLines != null) {
            this.setLore(meta, this.loreInterpreter.interpretLore(loreLines, player, this.activeMenu, builtTemplate, item, context));
        }
        itemStack.setItemMeta(meta);
    }

    public void setDisplayName(ItemMeta meta, Component component) {
        String displayName = this.tf.toString(component);
        if (displayName.contains("!!REMOVE!!")) {
            return;
        }
        PaperUtil.setDisplayName(meta, component);
    }

    public void setLore(ItemMeta meta, List<Component> components) {
        if (components.isEmpty()) {
            return;
        }
        PaperUtil.setLore(meta, components);
    }

    private void addSingleItemToInventory(SingleItem singleItem, ItemStack itemStack, List<SlotPos> positions, InventoryContents contents, Player player, BuiltItem builtItem) {
        for (SlotPos pos : positions) {
            contents.set(pos, ClickableItem.from(itemStack, c -> {
                Event patt0$temp = c.getEvent();
                if (!(patt0$temp instanceof InventoryClickEvent)) {
                    return;
                }
                InventoryClickEvent event = (InventoryClickEvent)patt0$temp;
                if (this.isOnCooldown(singleItem)) {
                    return;
                }
                if (this.failsClickConditions(singleItem, player, event)) {
                    return;
                }
                builtItem.handleClick(this.getClickTriggers(event.getClick()), new ItemClick(this.slate, player, event, c.getItem(), pos, this.activeMenu));
                this.executeClickActions(singleItem, player, contents, (ItemClickData)c);
            }));
        }
    }

    private <C> void addTemplateItemToInventory(TemplateItem<C> templateItem, ItemStack itemStack, List<SlotPos> positions, InventoryContents contents, Player player, BuiltTemplate<C> builtTemplate, C context) {
        for (SlotPos pos : positions) {
            contents.set(pos, ClickableItem.from(itemStack, c -> {
                Event patt0$temp = c.getEvent();
                if (!(patt0$temp instanceof InventoryClickEvent)) {
                    return;
                }
                InventoryClickEvent event = (InventoryClickEvent)patt0$temp;
                if (this.isOnCooldown(templateItem)) {
                    return;
                }
                if (this.failsClickConditions(templateItem, player, event)) {
                    return;
                }
                if (this.failsContextClickConditions(context, templateItem, player, event)) {
                    return;
                }
                builtTemplate.handleClick(this.getClickTriggers(event.getClick()), new TemplateClick<Object>(this.slate, player, event, c.getItem(), pos, this.activeMenu, context));
                this.executeClickActions(templateItem, player, contents, (ItemClickData)c, context);
            }));
        }
    }

    private boolean isOnCooldown(MenuItem menuItem) {
        ActiveItem activeItem = this.activeItems.get(menuItem.getName());
        return activeItem != null && activeItem.getCooldown() != 0;
    }

    private boolean failsClickConditions(MenuItem menuItem, Player player, InventoryClickEvent event) {
        for (ClickTrigger trigger : this.getClickTriggers(event.getClick())) {
            if (!menuItem.failsClickConditions(trigger, player, this)) continue;
            return true;
        }
        return false;
    }

    private <C> boolean failsContextClickConditions(C context, TemplateItem<C> template, Player player, InventoryClickEvent event) {
        for (ClickTrigger trigger : this.getClickTriggers(event.getClick())) {
            if (!template.failsContextClickConditions(context, trigger, player, this)) continue;
            return true;
        }
        return false;
    }

    private void executeClickActions(MenuItem menuItem, Player player, InventoryContents contents, ItemClickData clickData) {
        Event event = clickData.getEvent();
        if (!(event instanceof InventoryClickEvent)) {
            return;
        }
        InventoryClickEvent event2 = (InventoryClickEvent)event;
        this.executeActionsForClick(menuItem.getActions(), event2.getClick(), player, contents);
    }

    private <C> void executeClickActions(TemplateItem<C> menuItem, Player player, InventoryContents contents, ItemClickData clickData, C context) {
        Event event = clickData.getEvent();
        if (!(event instanceof InventoryClickEvent)) {
            return;
        }
        InventoryClickEvent event2 = (InventoryClickEvent)event;
        this.executeActionsForClick(menuItem.getActions(), event2.getClick(), player, contents);
        ItemActions contextActions = menuItem.getContextActions(context);
        if (contextActions != null) {
            this.executeActionsForClick(contextActions, event2.getClick(), player, contents);
        }
    }

    private void executeActionsForClick(ItemActions itemActions, ClickType type, Player player, InventoryContents contents) {
        Set<ClickTrigger> clickTriggers = this.getClickTriggers(type);
        Map<ClickTrigger, List<Action>> actions = itemActions.actions();
        for (Map.Entry<ClickTrigger, List<Action>> entry : actions.entrySet()) {
            ClickTrigger clickTrigger = entry.getKey();
            if (!clickTriggers.contains((Object)clickTrigger)) continue;
            for (Action action : entry.getValue()) {
                action.execute(player, this, contents);
            }
        }
    }

    private Set<ClickTrigger> getClickTriggers(ClickType clickType) {
        HashSet<ClickTrigger> clickTriggers = new HashSet<ClickTrigger>();
        clickTriggers.add(ClickTrigger.ANY);
        switch (clickType) {
            case LEFT: 
            case SHIFT_LEFT: {
                clickTriggers.add(ClickTrigger.LEFT);
                break;
            }
            case RIGHT: 
            case SHIFT_RIGHT: {
                clickTriggers.add(ClickTrigger.RIGHT);
                break;
            }
            case MIDDLE: {
                clickTriggers.add(ClickTrigger.MIDDLE);
                break;
            }
            case DROP: 
            case CONTROL_DROP: {
                clickTriggers.add(ClickTrigger.DROP);
            }
        }
        return clickTriggers;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    private void replaceItemPlaceholders(ItemStack item) {
        if (item == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof SkullMeta) {
            NamespacedKey key;
            SkullMeta skullMeta = (SkullMeta)meta;
            PersistentDataContainer container = skullMeta.getPersistentDataContainer();
            String placeholder = (String)container.get(key = new NamespacedKey((Plugin)this.slate.getPlugin(), "skull_placeholder_uuid"), PersistentDataType.STRING);
            if (placeholder != null) {
                placeholder = TextUtil.replace(placeholder, "{player}", this.player.getUniqueId().toString());
                if (this.slate.isPlaceholderAPIEnabled()) {
                    placeholder = PlaceholderAPI.setPlaceholders((Player)this.player, (String)placeholder);
                }
                try {
                    UUID uuid = UUID.fromString(placeholder);
                    skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)uuid));
                }
                catch (IllegalArgumentException e) {
                    this.slate.getPlugin().getLogger().warning("Error while opening menu: Unable to parse UUID for skull placeholder " + placeholder);
                }
            }
            item.setItemMeta((ItemMeta)skullMeta);
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public InventoryContents getContents() {
        return this.contents;
    }
}

