/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.item.parser;

import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.slate.Slate;
import dev.aurelium.auraskills.slate.action.ItemActions;
import dev.aurelium.auraskills.slate.action.condition.ItemConditions;
import dev.aurelium.auraskills.slate.action.parser.MenuActionParser;
import dev.aurelium.auraskills.slate.context.ContextGroup;
import dev.aurelium.auraskills.slate.context.ContextProvider;
import dev.aurelium.auraskills.slate.context.GroupAlign;
import dev.aurelium.auraskills.slate.inv.content.SlotPos;
import dev.aurelium.auraskills.slate.item.MenuItem;
import dev.aurelium.auraskills.slate.item.TemplateVariant;
import dev.aurelium.auraskills.slate.item.builder.TemplateItemBuilder;
import dev.aurelium.auraskills.slate.item.parser.MenuItemParser;
import dev.aurelium.auraskills.slate.lore.LoreLine;
import dev.aurelium.auraskills.slate.position.FixedPosition;
import dev.aurelium.auraskills.slate.position.GroupPosition;
import dev.aurelium.auraskills.slate.position.PositionProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TemplateItemParser<C>
extends MenuItemParser {
    @NotNull
    private final ContextProvider<C> contextProvider;

    public TemplateItemParser(Slate slate, @NotNull ContextProvider<C> contextProvider) {
        super(slate);
        this.contextProvider = contextProvider;
    }

    @Override
    public MenuItem parse(ConfigurationNode section, String menuName) {
        TemplateItemBuilder<Object> builder = new TemplateItemBuilder<Object>(this.slate);
        String name = (String)Objects.requireNonNull(section.key());
        builder.name(name);
        builder.contextClass(this.contextProvider.getType());
        Map<String, ContextGroup> groups = this.loadGroups(section);
        builder.contextGroups(groups);
        HashMap<C, ItemStack> baseItems = new HashMap<C, ItemStack>();
        HashMap<C, Record> positions = new HashMap<C, Record>();
        HashMap<C, String> contextualDisplayNames = new HashMap<C, String>();
        HashMap<C, List<LoreLine>> contextualLore = new HashMap<C, List<LoreLine>>();
        HashMap<C, ItemConditions> contextualConditions = new HashMap<C, ItemConditions>();
        HashMap<C, ItemActions> contextualActions = new HashMap<C, ItemActions>();
        for (ConfigurationNode configurationNode : section.node("contexts").childrenMap().values()) {
            List<LoreLine> contextualLoreList;
            String positionString;
            String key = configurationNode.key() instanceof String ? (String)Objects.requireNonNull(configurationNode.key()) : String.valueOf(configurationNode.key());
            C context = this.contextProvider.parse(menuName, key);
            if (context == null) continue;
            if (!configurationNode.node("material").virtual() || !configurationNode.node("key").virtual()) {
                baseItems.put(context, this.itemParser.parseBaseItem(configurationNode));
            }
            if ((positionString = configurationNode.node("pos").getString()) != null) {
                positions.put(context, new FixedPosition(this.parsePosition(positionString)));
            } else if (!configurationNode.node("group").virtual()) {
                String groupName = configurationNode.node("group").getString();
                ContextGroup group = groups.get(groupName);
                if (group == null) {
                    positions.put(context, new FixedPosition(this.parsePosition("0,0")));
                } else {
                    int order = configurationNode.node("order").getInt(1);
                    positions.put(context, new GroupPosition(group, order));
                }
            }
            String contextualDisplayName = this.itemParser.parseDisplayName(configurationNode);
            if (contextualDisplayName != null) {
                contextualDisplayNames.put(context, contextualDisplayName);
            }
            if (!(contextualLoreList = this.itemParser.parseLore(configurationNode)).isEmpty()) {
                contextualLore.put(context, contextualLoreList);
            }
            contextualConditions.put(context, this.getConditions(configurationNode, menuName));
            contextualActions.put(context, this.parseActions(configurationNode, menuName));
        }
        builder.contextualDisplayNames(contextualDisplayNames);
        builder.contextualLore(contextualLore);
        builder.contextualConditions(contextualConditions);
        builder.contextualActions(contextualActions);
        ConfigurationNode posNode = section.node("pos");
        if (positions.isEmpty() && !posNode.empty()) {
            PositionProvider positionProvider = this.parsePosition(section, groups);
            builder.defaultPosition(positionProvider);
        }
        builder.baseItems(baseItems);
        builder.positions(positions);
        builder.variants(this.parseVariants(section, menuName, groups));
        if (!section.node("material").virtual() || !section.node("key").virtual()) {
            builder.defaultBaseItem(this.itemParser.parseBaseItem(section));
        }
        this.parseCommonOptions(builder, section, menuName);
        return builder.build();
    }

    private List<TemplateVariant<C>> parseVariants(ConfigurationNode section, String menuName, Map<String, ContextGroup> groups) {
        ArrayList<TemplateVariant<C>> variants = new ArrayList<TemplateVariant<C>>();
        for (ConfigurationNode configurationNode : section.node("variants").childrenList()) {
            HashSet<C> contextFilters = new HashSet<C>();
            if (!configurationNode.node("contexts").empty()) {
                configurationNode.node("contexts").childrenList().stream().map(node -> this.contextProvider.parse(menuName, String.valueOf(node.raw()))).filter(Objects::nonNull).forEach(contextFilters::add);
            } else {
                String key = configurationNode.node("context").getString("");
                C context = this.contextProvider.parse(menuName, key);
                if (context != null) {
                    contextFilters.add(context);
                }
            }
            Map<String, Object> propertyFilters = new MenuActionParser(this.slate).getProperties(menuName, configurationNode);
            ItemStack baseItem = this.parseVariantBaseItem(configurationNode);
            PositionProvider positionProvider = this.parsePosition(configurationNode, groups);
            String displayName = this.itemParser.parseDisplayName(configurationNode);
            List<LoreLine> lore = this.itemParser.parseLore(configurationNode);
            TemplateVariant variant = new TemplateVariant(contextFilters, propertyFilters, baseItem, positionProvider, displayName, lore);
            variants.add(variant);
        }
        return variants;
    }

    private Map<String, ContextGroup> loadGroups(ConfigurationNode section) {
        HashMap<String, ContextGroup> groups = new HashMap<String, ContextGroup>();
        for (ConfigurationNode configurationNode : section.node("groups").childrenMap().values()) {
            String groupName = (String)configurationNode.key();
            if (groupName == null) continue;
            SlotPos start = this.parsePosition(configurationNode.node("start").getString("0,0"));
            SlotPos end = this.parsePosition(configurationNode.node("end").getString("0,0"));
            GroupAlign align = GroupAlign.valueOf(configurationNode.node("align").getString("CENTER").toUpperCase(Locale.ROOT));
            groups.put(groupName, new ContextGroup(start, end, align));
        }
        return groups;
    }
}

