/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.item.parser;

import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.slate.Slate;
import dev.aurelium.auraskills.slate.action.parser.MenuActionParser;
import dev.aurelium.auraskills.slate.inv.content.SlotPos;
import dev.aurelium.auraskills.slate.item.ItemVariant;
import dev.aurelium.auraskills.slate.item.MenuItem;
import dev.aurelium.auraskills.slate.item.builder.SingleItemBuilder;
import dev.aurelium.auraskills.slate.item.parser.MenuItemParser;
import dev.aurelium.auraskills.slate.lore.LoreLine;
import dev.aurelium.auraskills.slate.util.Validate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.inventory.ItemStack;

public class SingleItemParser
extends MenuItemParser {
    public SingleItemParser(Slate slate) {
        super(slate);
    }

    @Override
    public MenuItem parse(ConfigurationNode section, String menuName) {
        SingleItemBuilder builder = new SingleItemBuilder(this.slate);
        String name = (String)Objects.requireNonNull(section.key());
        builder.name(name);
        builder.baseItem(this.itemParser.parseBaseItem(section));
        builder.positions(this.parsePosList(section));
        builder.variants(this.parseVariants(section, menuName));
        this.parseCommonOptions(builder, section, menuName);
        return builder.build();
    }

    private List<ItemVariant> parseVariants(ConfigurationNode section, String menuName) {
        ArrayList<ItemVariant> variants = new ArrayList<ItemVariant>();
        for (ConfigurationNode configurationNode : section.node("variants").childrenList()) {
            Map<String, Object> propertyFilters = new MenuActionParser(this.slate).getProperties(menuName, configurationNode);
            ItemStack baseItem = this.parseVariantBaseItem(configurationNode);
            String displayName = this.itemParser.parseDisplayName(configurationNode);
            List<LoreLine> lore = this.itemParser.parseLore(configurationNode);
            List<SlotPos> pos = null;
            if (!configurationNode.node("pos").empty()) {
                pos = this.parsePosList(configurationNode);
            }
            ItemVariant variant = new ItemVariant(propertyFilters, baseItem, pos, displayName, lore);
            variants.add(variant);
        }
        return variants;
    }

    private List<SlotPos> parsePosList(ConfigurationNode section) {
        ConfigurationNode posNode = section.node("pos");
        if (posNode.isList()) {
            ArrayList<SlotPos> positions = new ArrayList<SlotPos>();
            for (ConfigurationNode configurationNode : posNode.childrenList()) {
                String positionString = configurationNode.getString();
                if (positionString == null) continue;
                positions.add(this.parsePosition(positionString));
            }
            return positions;
        }
        String positionString = posNode.getString();
        Validate.notNull(positionString, "Item must specify pos");
        return List.of(this.parsePosition(positionString));
    }
}

