/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.item.parser;

import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.slate.Slate;
import dev.aurelium.auraskills.slate.action.Action;
import dev.aurelium.auraskills.slate.action.ItemActions;
import dev.aurelium.auraskills.slate.action.condition.Condition;
import dev.aurelium.auraskills.slate.action.condition.ConditionParser;
import dev.aurelium.auraskills.slate.action.condition.ItemConditions;
import dev.aurelium.auraskills.slate.action.trigger.ClickTrigger;
import dev.aurelium.auraskills.slate.context.ContextGroup;
import dev.aurelium.auraskills.slate.inv.content.SlotPos;
import dev.aurelium.auraskills.slate.item.MenuItem;
import dev.aurelium.auraskills.slate.item.builder.MenuItemBuilder;
import dev.aurelium.auraskills.slate.item.parser.ConfigurateItemParser;
import dev.aurelium.auraskills.slate.menu.MenuLoader;
import dev.aurelium.auraskills.slate.position.FixedPosition;
import dev.aurelium.auraskills.slate.position.GroupPosition;
import dev.aurelium.auraskills.slate.position.MultiPosition;
import dev.aurelium.auraskills.slate.position.PositionProvider;
import dev.aurelium.auraskills.slate.util.MapParser;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class MenuItemParser
extends MapParser {
    protected final Slate slate;
    protected final ConfigurateItemParser itemParser;

    public MenuItemParser(Slate slate) {
        this.slate = slate;
        this.itemParser = new ConfigurateItemParser(slate);
    }

    public abstract MenuItem parse(ConfigurationNode var1, String var2);

    protected SlotPos parsePosition(String input) {
        String[] splitInput = input.split(",", 2);
        if (splitInput.length == 2) {
            int row = Integer.parseInt(splitInput[0]);
            int column = Integer.parseInt(splitInput[1]);
            return SlotPos.of(row, column);
        }
        int slot = Integer.parseInt(input);
        int row = slot / 9;
        int column = slot % 9;
        return SlotPos.of(row, column);
    }

    @Nullable
    protected PositionProvider parsePosition(ConfigurationNode variantNode, Map<String, ContextGroup> groups) {
        ConfigurationNode posNode = variantNode.node("pos");
        if (posNode.isList()) {
            ArrayList<SlotPos> positions = new ArrayList<SlotPos>();
            for (ConfigurationNode configurationNode : posNode.childrenList()) {
                String positionString = configurationNode.getString();
                if (positionString == null) continue;
                positions.add(this.parsePosition(positionString));
            }
            return new MultiPosition(positions);
        }
        String positionString = posNode.getString();
        if (positionString != null) {
            return new FixedPosition(this.parsePosition(positionString));
        }
        if (!variantNode.node("group").virtual()) {
            String groupName = variantNode.node("group").getString();
            ContextGroup contextGroup = groups.get(groupName);
            if (contextGroup == null) {
                return new FixedPosition(this.parsePosition("0,0"));
            }
            int order = variantNode.node("order").getInt(1);
            return new GroupPosition(contextGroup, order);
        }
        return null;
    }

    @Nullable
    protected ItemStack parseVariantBaseItem(ConfigurationNode variantNode) {
        if (!variantNode.node("material").virtual() || !variantNode.node("key").virtual()) {
            return this.itemParser.parseBaseItem(variantNode);
        }
        return null;
    }

    protected void parseCommonOptions(MenuItemBuilder builder, ConfigurationNode config, String menuName) {
        builder.displayName(this.itemParser.parseDisplayName(config));
        builder.lore(this.itemParser.parseLore(config));
        builder.actions(this.parseActions(config, menuName));
        builder.conditions(this.getConditions(config, menuName));
        builder.options(MenuLoader.loadOptions(config));
    }

    protected ItemActions parseActions(ConfigurationNode config, String menuName) {
        LinkedHashMap<ClickTrigger, List<Action>> actions = new LinkedHashMap<ClickTrigger, List<Action>>();
        for (ClickTrigger clickTrigger : ClickTrigger.values()) {
            String id = clickTrigger.getId();
            if (config.node(id).virtual()) continue;
            List<Action> clickActions = this.slate.getActionManager().parseActions(config.node(id), menuName);
            actions.put(clickTrigger, clickActions);
        }
        return new ItemActions(actions);
    }

    protected ItemConditions getConditions(ConfigurationNode config, String menuName) {
        return new ItemConditions(this.parseViewConditions(config, menuName), this.parseClickConditions(config, menuName));
    }

    private List<Condition> parseViewConditions(ConfigurationNode config, String menuName) {
        ConfigurationNode vcNode = config.node("view_conditions");
        if (!vcNode.virtual()) {
            return new ConditionParser(this.slate).parseConditions(vcNode, menuName);
        }
        return new ArrayList<Condition>();
    }

    private Map<ClickTrigger, List<Condition>> parseClickConditions(ConfigurationNode config, String menuName) {
        LinkedHashMap<ClickTrigger, List<Condition>> clickConditions = new LinkedHashMap<ClickTrigger, List<Condition>>();
        for (ClickTrigger clickTrigger : ClickTrigger.values()) {
            String id = clickTrigger.getId();
            String condListKey = id + "_conditions";
            if (config.node(condListKey).virtual()) continue;
            List<Condition> conditionList = new ConditionParser(this.slate).parseConditions(config.node(condListKey), menuName);
            clickConditions.put(clickTrigger, conditionList);
        }
        return clickConditions;
    }
}

