/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.builder;

import dev.aurelium.auraskills.slate.action.trigger.ClickTrigger;
import dev.aurelium.auraskills.slate.builder.BuiltTemplate;
import dev.aurelium.auraskills.slate.function.ContextListener;
import dev.aurelium.auraskills.slate.function.DefinedContexts;
import dev.aurelium.auraskills.slate.function.MenuListener;
import dev.aurelium.auraskills.slate.function.TemplateClicker;
import dev.aurelium.auraskills.slate.function.TemplateModifier;
import dev.aurelium.auraskills.slate.function.TemplateReplacer;
import dev.aurelium.auraskills.slate.function.TemplateSlot;
import dev.aurelium.auraskills.slate.info.ItemInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class TemplateBuilder<T> {
    private final Class<T> contextType;
    private final Map<String, TemplateReplacer<T>> replacers = new HashMap<String, TemplateReplacer<T>>();
    private TemplateReplacer<T> anyReplacer = p -> null;
    private final Map<ClickTrigger, TemplateClicker<T>> clickers = new HashMap<ClickTrigger, TemplateClicker<T>>();
    private TemplateModifier<T> modifier = ItemInfo::item;
    private DefinedContexts<T> definedContexts = m -> new HashSet();
    private TemplateSlot<T> slotProvider = t -> null;
    private MenuListener initListener = m -> {};
    private ContextListener<T> contextListener = t -> {};

    public TemplateBuilder(Class<T> contextType) {
        this.contextType = contextType;
    }

    public static <T> TemplateBuilder<T> builder(Class<T> type) {
        return new TemplateBuilder<T>(type);
    }

    public TemplateBuilder<T> replace(String from, TemplateReplacer<T> replacer) {
        this.replacers.put(from, replacer);
        return this;
    }

    public TemplateBuilder<T> replaceAny(TemplateReplacer<T> replacer) {
        this.anyReplacer = replacer;
        return this;
    }

    public TemplateBuilder<T> onClick(TemplateClicker<T> clicker) {
        this.clickers.put(ClickTrigger.ANY, clicker);
        return this;
    }

    public TemplateBuilder<T> onClick(ClickTrigger action, TemplateClicker<T> clicker) {
        this.clickers.put(action, clicker);
        return this;
    }

    public TemplateBuilder<T> modify(TemplateModifier<T> modifier) {
        this.modifier = modifier;
        return this;
    }

    public TemplateBuilder<T> definedContexts(DefinedContexts<T> context) {
        this.definedContexts = context;
        return this;
    }

    public TemplateBuilder<T> slotPos(TemplateSlot<T> slot) {
        this.slotProvider = slot;
        return this;
    }

    public TemplateBuilder<T> initialize(MenuListener listener) {
        this.initListener = listener;
        return this;
    }

    public TemplateBuilder<T> initializeContext(ContextListener<T> listener) {
        this.contextListener = listener;
        return this;
    }

    public BuiltTemplate<T> build() {
        return new BuiltTemplate<T>(this.contextType, this.replacers, this.anyReplacer, this.clickers, this.modifier, this.definedContexts, this.slotProvider, this.initListener, this.contextListener);
    }
}

