/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.builder;

import dev.aurelium.auraskills.slate.action.trigger.ClickTrigger;
import dev.aurelium.auraskills.slate.builder.BuiltItem;
import dev.aurelium.auraskills.slate.function.ItemClicker;
import dev.aurelium.auraskills.slate.function.ItemModifier;
import dev.aurelium.auraskills.slate.function.ItemReplacer;
import dev.aurelium.auraskills.slate.function.MenuListener;
import dev.aurelium.auraskills.slate.info.ItemInfo;
import java.util.HashMap;
import java.util.Map;

public class ItemBuilder {
    private final Map<String, ItemReplacer> replacers = new HashMap<String, ItemReplacer>();
    private ItemReplacer anyReplacer = p -> null;
    private final Map<ClickTrigger, ItemClicker> clickers = new HashMap<ClickTrigger, ItemClicker>();
    private ItemModifier modifier = ItemInfo::item;
    private MenuListener initListener = m -> {};

    public static ItemBuilder builder() {
        return new ItemBuilder();
    }

    public ItemBuilder replace(String from, ItemReplacer replacer) {
        this.replacers.put(from, replacer);
        return this;
    }

    public ItemBuilder replaceAny(ItemReplacer replacer) {
        this.anyReplacer = replacer;
        return this;
    }

    public ItemBuilder onClick(ItemClicker clicker) {
        this.clickers.put(ClickTrigger.ANY, clicker);
        return this;
    }

    public ItemBuilder onClick(ClickTrigger action, ItemClicker clicker) {
        this.clickers.put(action, clicker);
        return this;
    }

    public ItemBuilder modify(ItemModifier modifier) {
        this.modifier = modifier;
        return this;
    }

    public ItemBuilder initialize(MenuListener listener) {
        this.initListener = listener;
        return this;
    }

    public BuiltItem build() {
        return new BuiltItem(this.replacers, this.anyReplacer, this.clickers, this.modifier, this.initListener);
    }
}

