/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.querz.nbt.io;

import dev.aurelium.auraskills.querz.io.MaxDepthIO;
import dev.aurelium.auraskills.querz.nbt.tag.ByteArrayTag;
import dev.aurelium.auraskills.querz.nbt.tag.ByteTag;
import dev.aurelium.auraskills.querz.nbt.tag.CompoundTag;
import dev.aurelium.auraskills.querz.nbt.tag.DoubleTag;
import dev.aurelium.auraskills.querz.nbt.tag.FloatTag;
import dev.aurelium.auraskills.querz.nbt.tag.IntArrayTag;
import dev.aurelium.auraskills.querz.nbt.tag.IntTag;
import dev.aurelium.auraskills.querz.nbt.tag.ListTag;
import dev.aurelium.auraskills.querz.nbt.tag.LongArrayTag;
import dev.aurelium.auraskills.querz.nbt.tag.LongTag;
import dev.aurelium.auraskills.querz.nbt.tag.ShortTag;
import dev.aurelium.auraskills.querz.nbt.tag.StringTag;
import dev.aurelium.auraskills.querz.nbt.tag.Tag;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.regex.Pattern;

public final class SNBTWriter
implements MaxDepthIO {
    private static final Pattern NON_QUOTE_PATTERN = Pattern.compile("[a-zA-Z_.+\\-]+");
    private Writer writer;

    private SNBTWriter(Writer writer) {
        this.writer = writer;
    }

    public static void write(Tag<?> tag, Writer writer, int maxDepth) throws IOException {
        new SNBTWriter(writer).writeAnything(tag, maxDepth);
    }

    public static void write(Tag<?> tag, Writer writer) throws IOException {
        SNBTWriter.write(tag, writer, 512);
    }

    private void writeAnything(Tag<?> tag, int maxDepth) throws IOException {
        switch (tag.getID()) {
            case 0: {
                break;
            }
            case 1: {
                this.writer.append(Byte.toString(((ByteTag)tag).asByte())).write(98);
                break;
            }
            case 2: {
                this.writer.append(Short.toString(((ShortTag)tag).asShort())).write(115);
                break;
            }
            case 3: {
                this.writer.write(Integer.toString(((IntTag)tag).asInt()));
                break;
            }
            case 4: {
                this.writer.append(Long.toString(((LongTag)tag).asLong())).write(108);
                break;
            }
            case 5: {
                this.writer.append(Float.toString(((FloatTag)tag).asFloat())).write(102);
                break;
            }
            case 6: {
                this.writer.append(Double.toString(((DoubleTag)tag).asDouble())).write(100);
                break;
            }
            case 7: {
                this.writeArray(((ByteArrayTag)tag).getValue(), ((ByteArrayTag)tag).length(), "B");
                break;
            }
            case 8: {
                this.writer.write(SNBTWriter.escapeString(((StringTag)tag).getValue()));
                break;
            }
            case 9: {
                this.writer.write(91);
                for (int i = 0; i < ((ListTag)tag).size(); ++i) {
                    this.writer.write(i == 0 ? "" : ",");
                    this.writeAnything((Tag<?>)((ListTag)tag).get(i), this.decrementMaxDepth(maxDepth));
                }
                this.writer.write(93);
                break;
            }
            case 10: {
                this.writer.write(123);
                boolean first = true;
                for (Map.Entry<String, Tag<?>> entry : (CompoundTag)tag) {
                    this.writer.write(first ? "" : ",");
                    this.writer.append(SNBTWriter.escapeString(entry.getKey())).write(58);
                    this.writeAnything(entry.getValue(), this.decrementMaxDepth(maxDepth));
                    first = false;
                }
                this.writer.write(125);
                break;
            }
            case 11: {
                this.writeArray(((IntArrayTag)tag).getValue(), ((IntArrayTag)tag).length(), "I");
                break;
            }
            case 12: {
                this.writeArray(((LongArrayTag)tag).getValue(), ((LongArrayTag)tag).length(), "L");
                break;
            }
            default: {
                throw new IOException("unknown tag with id \"" + tag.getID() + "\"");
            }
        }
    }

    private void writeArray(Object array, int length, String prefix) throws IOException {
        this.writer.append('[').append(prefix).write(59);
        for (int i = 0; i < length; ++i) {
            this.writer.append(i == 0 ? "" : ",").write(Array.get(array, i).toString());
        }
        this.writer.write(93);
    }

    public static String escapeString(String s) {
        if (!NON_QUOTE_PATTERN.matcher(s).matches()) {
            StringBuilder sb = new StringBuilder();
            sb.append('\"');
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '\\' || c == '\"') {
                    sb.append('\\');
                }
                sb.append(c);
            }
            sb.append('\"');
            return sb.toString();
        }
        return s;
    }
}

