/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.querz.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public interface Serializer<T> {
    public void toStream(T var1, OutputStream var2) throws IOException;

    default public void toFile(T object, File file) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));){
            this.toStream(object, bos);
        }
    }

    default public byte[] toBytes(T object) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.toStream(object, bos);
        bos.close();
        return bos.toByteArray();
    }
}

