/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.polyglot.lang;

import dev.aurelium.auraskills.configurate.CommentedConfigurationNode;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.NodePath;
import dev.aurelium.auraskills.configurate.loader.HeaderMode;
import dev.aurelium.auraskills.configurate.serialize.SerializationException;
import dev.aurelium.auraskills.configurate.yaml.NodeStyle;
import dev.aurelium.auraskills.configurate.yaml.YamlConfigurationLoader;
import dev.aurelium.auraskills.polyglot.Polyglot;
import dev.aurelium.auraskills.polyglot.lang.MessageLoader;
import dev.aurelium.auraskills.polyglot.lang.MessageUpdate;
import dev.aurelium.auraskills.polyglot.util.TextUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class FileUpdater {
    private final Polyglot polyglot;
    private final MessageLoader messageLoader;

    public FileUpdater(Polyglot polyglot, MessageLoader messageLoader) {
        this.polyglot = polyglot;
        this.messageLoader = messageLoader;
    }

    public void updateFile(File file, String fileName, List<MessageUpdate> messageUpdates) {
        try {
            YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(file.toPath())).nodeStyle(NodeStyle.BLOCK).headerMode(HeaderMode.PRESERVE)).indent(2).build();
            CommentedConfigurationNode userRoot = (CommentedConfigurationNode)loader.load();
            InputStream embeddedInputStream = this.polyglot.getProvider().getResource(this.polyglot.getConfig().getMessageDirectory() + "/" + fileName);
            if (embeddedInputStream == null) {
                String defFileName = TextUtil.replace(this.polyglot.getConfig().getMessageFileName(), "{language}", this.polyglot.getConfig().getDefaultLanguage());
                embeddedInputStream = this.polyglot.getProvider().getResource(this.polyglot.getConfig().getMessageDirectory() + "/" + defFileName);
                if (embeddedInputStream == null) {
                    return;
                }
            }
            CommentedConfigurationNode embeddedRoot = this.messageLoader.loadYamlFile(embeddedInputStream);
            if (((CommentedConfigurationNode)userRoot.node(new Object[]{"file_version"})).virtual()) {
                throw new IllegalArgumentException("Message file " + fileName + " is missing a file_version");
            }
            if (((CommentedConfigurationNode)embeddedRoot.node(new Object[]{"file_version"})).virtual()) {
                throw new IllegalStateException("Embedded message file " + fileName + " is missing a file_version");
            }
            int userFileVersion = ((CommentedConfigurationNode)userRoot.node(new Object[]{"file_version"})).getInt();
            int embeddedFileVersion = ((CommentedConfigurationNode)embeddedRoot.node(new Object[]{"file_version"})).getInt();
            AtomicInteger keysAdded = new AtomicInteger();
            if (userFileVersion == embeddedFileVersion) {
                return;
            }
            this.updateChildren(embeddedRoot, userRoot, keysAdded);
            this.applyMessageUpdates(messageUpdates, userRoot, embeddedRoot, userFileVersion, embeddedFileVersion, fileName);
            ((CommentedConfigurationNode)userRoot.node(new Object[]{"file_version"})).set(embeddedFileVersion);
            loader.save(userRoot);
            this.polyglot.getProvider().logInfo(fileName + " was updated to a new file version, " + keysAdded.get() + " new keys were added.");
        }
        catch (Exception e) {
            this.polyglot.getProvider().logWarn("Error updating file " + file.getName());
            e.printStackTrace();
        }
    }

    private void updateChildren(ConfigurationNode embedded, ConfigurationNode userRoot, AtomicInteger keysAdded) throws SerializationException {
        for (ConfigurationNode configurationNode : embedded.childrenMap().values()) {
            if ("file_version".equals(configurationNode.key())) continue;
            String message = configurationNode.getString();
            if (message != null) {
                if (!userRoot.node(configurationNode.path()).virtual()) continue;
                userRoot.node(configurationNode.path()).set(message);
                keysAdded.incrementAndGet();
                continue;
            }
            this.updateChildren(configurationNode, userRoot, keysAdded);
        }
    }

    private void applyMessageUpdates(List<MessageUpdate> messageUpdates, ConfigurationNode userRoot, ConfigurationNode embeddedRoot, int userVersion, int embeddedVersion, String fileName) throws SerializationException {
        for (MessageUpdate update : messageUpdates) {
            if (userVersion >= update.getVersion() || embeddedVersion < update.getVersion()) continue;
            NodePath path = this.convertToPath(update.getPath());
            ConfigurationNode userNode = userRoot.node(path);
            ConfigurationNode embeddedNode = embeddedRoot.node(path);
            userNode.set(embeddedNode.raw());
            if (update.getMessage() == null) continue;
            this.polyglot.getProvider().logWarn(fileName + " was changed: " + update.getMessage());
        }
    }

    private NodePath convertToPath(String stringPath) {
        String[] split = stringPath.split("\\.");
        ArrayList elements = new ArrayList();
        Collections.addAll(elements, split);
        return NodePath.of(elements);
    }
}

