/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.evalex.operators.arithmetic;

import dev.aurelium.auraskills.evalex.EvaluationException;
import dev.aurelium.auraskills.evalex.Expression;
import dev.aurelium.auraskills.evalex.data.EvaluationValue;
import dev.aurelium.auraskills.evalex.operators.AbstractOperator;
import dev.aurelium.auraskills.evalex.operators.InfixOperator;
import dev.aurelium.auraskills.evalex.parser.Token;

@InfixOperator(precedence=30)
public class InfixMultiplicationOperator
extends AbstractOperator {
    @Override
    public EvaluationValue evaluate(Expression expression, Token operatorToken, EvaluationValue ... operands) throws EvaluationException {
        EvaluationValue leftOperand = operands[0];
        EvaluationValue rightOperand = operands[1];
        if (leftOperand.isNumberValue() && rightOperand.isNumberValue()) {
            return expression.convertValue(leftOperand.getNumberValue().multiply(rightOperand.getNumberValue(), expression.getConfiguration().getMathContext()));
        }
        throw EvaluationException.ofUnsupportedDataTypeInOperation(operatorToken);
    }
}

