/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.evalex.operators.arithmetic;

import dev.aurelium.auraskills.evalex.EvaluationException;
import dev.aurelium.auraskills.evalex.Expression;
import dev.aurelium.auraskills.evalex.data.EvaluationValue;
import dev.aurelium.auraskills.evalex.operators.AbstractOperator;
import dev.aurelium.auraskills.evalex.operators.InfixOperator;
import dev.aurelium.auraskills.evalex.parser.Token;
import java.math.BigDecimal;

@InfixOperator(precedence=30)
public class InfixModuloOperator
extends AbstractOperator {
    @Override
    public EvaluationValue evaluate(Expression expression, Token operatorToken, EvaluationValue ... operands) throws EvaluationException {
        EvaluationValue leftOperand = operands[0];
        EvaluationValue rightOperand = operands[1];
        if (leftOperand.isNumberValue() && rightOperand.isNumberValue()) {
            if (rightOperand.getNumberValue().equals(BigDecimal.ZERO)) {
                throw new EvaluationException(operatorToken, "Division by zero");
            }
            return expression.convertValue(leftOperand.getNumberValue().remainder(rightOperand.getNumberValue(), expression.getConfiguration().getMathContext()));
        }
        throw EvaluationException.ofUnsupportedDataTypeInOperation(operatorToken);
    }
}

