/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.evalex.functions.trigonometric;

import dev.aurelium.auraskills.evalex.EvaluationException;
import dev.aurelium.auraskills.evalex.Expression;
import dev.aurelium.auraskills.evalex.data.EvaluationValue;
import dev.aurelium.auraskills.evalex.functions.AbstractFunction;
import dev.aurelium.auraskills.evalex.functions.FunctionParameter;
import dev.aurelium.auraskills.evalex.parser.Token;
import java.math.BigDecimal;

@FunctionParameter(name="value")
public class AcosFunction
extends AbstractFunction {
    @Override
    public EvaluationValue evaluate(Expression expression, Token functionToken, EvaluationValue ... parameterValues) throws EvaluationException {
        BigDecimal parameterValue = parameterValues[0].getNumberValue();
        if (parameterValue.compareTo(BigDecimal.ONE) > 0) {
            throw new EvaluationException(functionToken, "Illegal acos(x) for x > 1: x = " + parameterValue);
        }
        if (parameterValue.compareTo(MINUS_ONE) < 0) {
            throw new EvaluationException(functionToken, "Illegal acos(x) for x < -1: x = " + parameterValue);
        }
        return expression.convertDoubleValue(Math.toDegrees(Math.acos(parameterValue.doubleValue())));
    }
}

