/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.evalex.functions.basic;

import dev.aurelium.auraskills.evalex.Expression;
import dev.aurelium.auraskills.evalex.data.EvaluationValue;
import dev.aurelium.auraskills.evalex.functions.FunctionParameter;
import dev.aurelium.auraskills.evalex.functions.FunctionParameters;
import dev.aurelium.auraskills.evalex.functions.basic.AbstractMinMaxFunction;
import dev.aurelium.auraskills.evalex.parser.Token;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;

@FunctionParameters(value={@FunctionParameter(name="firstValue"), @FunctionParameter(name="additionalValues", isVarArg=true)})
public class AverageFunction
extends AbstractMinMaxFunction {
    @Override
    public EvaluationValue evaluate(Expression expression, Token functionToken, EvaluationValue ... parameterValues) {
        MathContext mathContext = expression.getConfiguration().getMathContext();
        BigDecimal sum = Arrays.stream(parameterValues).map(EvaluationValue::getNumberValue).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal count = BigDecimal.valueOf(parameterValues.length);
        BigDecimal average = sum.divide(count, mathContext);
        return expression.convertValue(average);
    }
}

