/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.configurate.objectmapping;

import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.objectmapping.FieldData;
import dev.aurelium.auraskills.configurate.objectmapping.FieldDiscoverer;
import dev.aurelium.auraskills.configurate.objectmapping.ObjectMapper;
import dev.aurelium.auraskills.configurate.objectmapping.meta.PostProcessor;
import dev.aurelium.auraskills.configurate.objectmapping.meta.Processor;
import dev.aurelium.auraskills.configurate.serialize.SerializationException;
import dev.aurelium.auraskills.configurate.serialize.TypeSerializer;
import dev.aurelium.auraskills.configurate.util.CheckedFunction;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

class ObjectMapperImpl<I, V>
implements ObjectMapper<V> {
    private final Type type;
    private final List<FieldData<I, V>> fields;
    final FieldDiscoverer.InstanceFactory<I> instanceFactory;
    private final List<PostProcessor> postProcessors;

    ObjectMapperImpl(Type type, List<FieldData<I, V>> fields, FieldDiscoverer.InstanceFactory<I> instanceFactory, List<PostProcessor> postProcessors) {
        this.type = type;
        this.fields = Collections.unmodifiableList(fields);
        this.instanceFactory = instanceFactory;
        this.postProcessors = postProcessors;
    }

    @Override
    public V load(ConfigurationNode source) throws SerializationException {
        return (V)this.load0(source, intermediate -> this.instanceFactory.complete(intermediate));
    }

    final V load0(ConfigurationNode source, CheckedFunction<I, V, SerializationException> completer) throws SerializationException {
        I intermediate = this.instanceFactory.begin();
        ArrayList<FieldData<I, V>> unseenFields = null;
        SerializationException failure = null;
        for (FieldData<I, V> field : this.fields) {
            @Nullable ConfigurationNode configurationNode = field.resolveNode(source);
            if (configurationNode == null) continue;
            try {
                TypeSerializer<?> serial = field.serializerFrom(configurationNode);
                Object newVal = configurationNode.isNull() ? null : serial.deserialize(field.resolvedType(), configurationNode);
                field.validate(newVal);
                Supplier<@Nullable Object> implicitInitializer = newVal == null && configurationNode.options().implicitInitialization() ? () -> serial.emptyValue(field.resolvedType(), node.options()) : () -> null;
                field.deserializer().accept(intermediate, newVal, implicitInitializer);
                if (newVal != null || !source.options().shouldCopyDefaults()) continue;
                if (unseenFields == null) {
                    unseenFields = new ArrayList<FieldData<I, V>>();
                }
                unseenFields.add(field);
            }
            catch (SerializationException ex) {
                ex.initPath(configurationNode::path);
                ex.initType(field.resolvedType());
                if (failure == null) {
                    failure = ex;
                    continue;
                }
                failure.addSuppressed(ex);
            }
        }
        if (failure != null) {
            throw failure;
        }
        V complete = completer.apply(intermediate);
        for (PostProcessor postProcessor : this.postProcessors) {
            try {
                postProcessor.postProcess(complete);
            }
            catch (SerializationException ex) {
                if (failure == null) {
                    failure = ex;
                    continue;
                }
                failure.addSuppressed(ex);
            }
        }
        if (failure != null) {
            throw failure;
        }
        if (unseenFields != null) {
            for (FieldData fieldData : unseenFields) {
                this.saveSingle(fieldData, complete, source);
            }
        }
        return complete;
    }

    @Override
    public void save(V value, ConfigurationNode target) throws SerializationException {
        for (FieldData<I, V> field : this.fields) {
            this.saveSingle(field, value, target);
        }
        if (target.virtual()) {
            target.set(Collections.emptyMap());
        }
    }

    private void saveSingle(FieldData<I, V> field, V value, ConfigurationNode target) throws SerializationException {
        @Nullable ConfigurationNode node = field.resolveNode(target);
        if (node == null) {
            return;
        }
        try {
            Object fieldVal;
            try {
                fieldVal = field.serializer().apply(value);
            }
            catch (SerializationException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new SerializationException(node, field.resolvedType(), (Throwable)ex);
            }
            if (fieldVal == null) {
                node.set(null);
            } else {
                TypeSerializer<?> serial = field.serializerFrom(node);
                serial.serialize(field.resolvedType(), fieldVal, node);
                for (Processor<?> processor : field.processors()) {
                    processor.process(fieldVal, node);
                }
            }
        }
        catch (SerializationException ex) {
            ex.initPath(node::path);
            ex.initType(field.resolvedType());
            throw ex;
        }
    }

    @Override
    public List<FieldData<I, V>> fields() {
        return this.fields;
    }

    @Override
    public Type mappedType() {
        return this.type;
    }

    @Override
    public boolean canCreateInstances() {
        return this.instanceFactory.canCreateInstances();
    }

    static final class Mutable<I, V>
    extends ObjectMapperImpl<I, V>
    implements ObjectMapper.Mutable<V> {
        Mutable(Type type, List<FieldData<I, V>> fields, FieldDiscoverer.MutableInstanceFactory<I> instanceFactory, List<PostProcessor> postProcessors) {
            super(type, fields, instanceFactory, postProcessors);
        }

        @Override
        public void load(V value, ConfigurationNode node) throws SerializationException {
            this.load0(node, intermediate -> {
                ((FieldDiscoverer.MutableInstanceFactory)this.instanceFactory).complete(value, intermediate);
                return value;
            });
        }
    }
}

