/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.util.text;

import java.time.Duration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DurationParser {
    private static final Pattern DURATION_PATTERN = Pattern.compile("(?:(\\d+)y)?(?:(\\d+)mo)?(?:(\\d+)d)?(?:(\\d+)h)?(?:(\\d+)m)?(?:(\\d+)s)?");

    private DurationParser() {
    }

    public static Duration parse(String input) {
        Matcher matcher = DURATION_PATTERN.matcher(input);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid duration format: " + input);
        }
        long years = DurationParser.parseNumber(matcher.group(1));
        long months = DurationParser.parseNumber(matcher.group(2));
        long days = DurationParser.parseNumber(matcher.group(3));
        long hours = DurationParser.parseNumber(matcher.group(4));
        long minutes = DurationParser.parseNumber(matcher.group(5));
        long seconds = DurationParser.parseNumber(matcher.group(6));
        long totalDays = days + months * 30L + years * 365L;
        return Duration.ofDays(totalDays).plusHours(hours).plusMinutes(minutes).plusSeconds(seconds);
    }

    public static String toString(Duration duration) {
        long totalSeconds = duration.getSeconds();
        long totalDays = totalSeconds / 86400L;
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        long years = totalDays / 365L;
        long months = (totalDays %= 365L) / 30L;
        long days = totalDays % 30L;
        StringBuilder sb = new StringBuilder();
        if (years > 0L) {
            sb.append(years).append("y");
        }
        if (months > 0L) {
            sb.append(months).append("mo");
        }
        if (days > 0L) {
            sb.append(days).append("d");
        }
        if (hours > 0L) {
            sb.append(hours).append("h");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("m");
        }
        if (seconds > 0L) {
            sb.append(seconds).append("s");
        }
        return sb.isEmpty() ? "0s" : sb.toString();
    }

    private static long parseNumber(String group) {
        return group == null ? 0L : Long.parseLong(group);
    }
}

