/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.user;

import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.ref.PlayerRef;
import dev.aurelium.auraskills.common.skill.LoadedSkill;
import dev.aurelium.auraskills.common.user.User;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public abstract class UserManager {
    private final AuraSkillsPlugin plugin;
    protected final Map<UUID, User> playerDataMap = new ConcurrentHashMap<UUID, User>();

    public UserManager(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
    }

    public abstract User instantiateUser(UUID var1, PlayerRef var2);

    public abstract List<User> getOnlineUsers();

    public User getUser(UUID uuid) {
        return this.playerDataMap.get(uuid);
    }

    public void addUser(User user) {
        this.playerDataMap.put(user.getUuid(), user);
    }

    public void removeUser(UUID uuid) {
        this.playerDataMap.remove(uuid);
    }

    public boolean hasUser(UUID uuid) {
        return this.playerDataMap.containsKey(uuid);
    }

    public Map<UUID, User> getUserMap() {
        return this.playerDataMap;
    }

    public User createNewUser(UUID uuid, @Nullable PlayerRef ref) {
        User user = this.instantiateUser(uuid, ref);
        for (LoadedSkill loadedSkill : this.plugin.getSkillManager().getSkills()) {
            user.setSkillLevel(loadedSkill.skill(), this.plugin.config().getStartLevel());
            user.setSkillXp(loadedSkill.skill(), 0.0);
        }
        return user;
    }
}

