/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.ui;

import com.google.common.collect.Sets;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.hooks.PlaceholderHook;
import dev.aurelium.auraskills.common.message.type.ActionBarMessage;
import dev.aurelium.auraskills.common.scheduler.TaskRunnable;
import dev.aurelium.auraskills.common.ui.ActionBarType;
import dev.aurelium.auraskills.common.ui.UiProvider;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public abstract class ActionBarManager {
    public static final int PAUSE_MS = 750;
    protected final AuraSkillsPlugin plugin;
    private final UiProvider uiProvider;
    private final Set<UUID> isPaused = Sets.newConcurrentHashSet();
    private final Set<UUID> isGainingXp = Sets.newConcurrentHashSet();
    private final Map<UUID, Integer> timer = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, Integer> currentAction = new ConcurrentHashMap<UUID, Integer>();
    private final Map<Locale, String> idleMessageCache = new ConcurrentHashMap<Locale, String>();

    public ActionBarManager(AuraSkillsPlugin plugin, UiProvider uiProvider) {
        this.plugin = plugin;
        this.uiProvider = uiProvider;
        this.startTimerCountdown();
        this.startUpdatingIdleActionBar();
    }

    public void startTimerCountdown() {
        TaskRunnable task = new TaskRunnable(){

            @Override
            public void run() {
                if (!ActionBarManager.this.plugin.configBoolean(Option.ACTION_BAR_ENABLED)) {
                    return;
                }
                for (User user : ActionBarManager.this.plugin.getUserManager().getOnlineUsers()) {
                    UUID uuid = user.getUuid();
                    Integer time = ActionBarManager.this.timer.get(uuid);
                    if (time != null) {
                        if (time <= 0) continue;
                        ActionBarManager.this.timer.put(uuid, time - 1);
                        continue;
                    }
                    ActionBarManager.this.timer.put(uuid, 0);
                }
            }
        };
        this.plugin.getScheduler().timerSync(task, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    public void startUpdatingIdleActionBar() {
        TaskRunnable task = new TaskRunnable(){

            @Override
            public void run() {
                if (!ActionBarManager.this.plugin.configBoolean(Option.ACTION_BAR_IDLE) || !ActionBarManager.this.plugin.configBoolean(Option.ACTION_BAR_ENABLED)) {
                    return;
                }
                for (User user : ActionBarManager.this.plugin.getUserManager().getOnlineUsers()) {
                    String base;
                    UUID uuid = user.getUuid();
                    if (!user.isActionBarEnabled(ActionBarType.IDLE) || ActionBarManager.this.plugin.getWorldManager().isDisabledWorld(ActionBarManager.this.getWorldName(user))) continue;
                    if (!ActionBarManager.this.currentAction.containsKey(uuid)) {
                        ActionBarManager.this.currentAction.put(uuid, 0);
                    }
                    if (ActionBarManager.this.isGainingXp.contains(uuid) || ActionBarManager.this.isPaused.contains(uuid)) continue;
                    boolean formatLast = ActionBarManager.this.plugin.configBoolean(Option.ACTION_BAR_FORMAT_LAST);
                    Locale locale = user.getLocale();
                    if (formatLast) {
                        base = ActionBarManager.this.plugin.getMessageProvider().getRaw(ActionBarMessage.IDLE, locale);
                    } else {
                        String cache = ActionBarManager.this.idleMessageCache.get(locale);
                        if (cache != null) {
                            base = cache;
                        } else {
                            base = ActionBarManager.this.plugin.getMsg(ActionBarMessage.IDLE, locale);
                            ActionBarManager.this.idleMessageCache.put(locale, base);
                        }
                    }
                    String message = TextUtil.replace(base, "{hp}", ActionBarManager.this.getHp(user), "{max_hp}", ActionBarManager.this.getMaxHp(user), "{mana}", ActionBarManager.this.getMana(user), "{max_mana}", ActionBarManager.this.getMaxMana(user));
                    message = ActionBarManager.this.replacePlaceholderApi(user, message);
                    if (formatLast) {
                        message = ActionBarManager.this.plugin.getMessageProvider().applyFormatting(message);
                    }
                    ActionBarManager.this.uiProvider.sendActionBar(user, message);
                }
            }
        };
        if (this.plugin.configBoolean(Option.ACTION_BAR_UPDATE_ASYNC)) {
            this.plugin.getScheduler().timerAsync(task, 0L, (long)this.plugin.configInt(Option.ACTION_BAR_UPDATE_PERIOD) * 50L, TimeUnit.MILLISECONDS);
        } else {
            this.plugin.getScheduler().timerSync(task, 0L, (long)this.plugin.configInt(Option.ACTION_BAR_UPDATE_PERIOD) * 50L, TimeUnit.MILLISECONDS);
        }
    }

    public void sendXpActionBar(final User user, final Skill skill, final double currentXp, final double levelXp, final double xpGained, final int level, final boolean maxed, final double income) {
        ActionBarType sendType;
        ActionBarType actionBarType = sendType = maxed ? ActionBarType.MAXED : ActionBarType.XP;
        if (!this.plugin.configBoolean(sendType.getOption()) || !this.plugin.configBoolean(Option.ACTION_BAR_ENABLED)) {
            return;
        }
        if (!user.isActionBarEnabled(sendType)) {
            return;
        }
        final UUID uuid = user.getUuid();
        if (this.isPaused.contains(uuid)) {
            return;
        }
        this.isGainingXp.add(uuid);
        this.timer.put(uuid, 20);
        final int thisAction = this.currentAction.getOrDefault(uuid, 0) + 1;
        this.currentAction.put(uuid, thisAction);
        this.plugin.getScheduler().timerSync(new TaskRunnable(){

            @Override
            public void run() {
                if (!ActionBarManager.this.isGainingXp.contains(uuid)) {
                    this.cancel();
                    return;
                }
                Integer actionNum = ActionBarManager.this.currentAction.get(uuid);
                if (actionNum == null) {
                    this.cancel();
                    return;
                }
                if (thisAction != actionNum) {
                    this.cancel();
                    return;
                }
                String message = ActionBarManager.this.getXpActionBarMessage(user, skill, currentXp, levelXp, xpGained, level, maxed, income);
                ActionBarManager.this.uiProvider.sendActionBar(user, message);
            }
        }, 0L, (long)this.plugin.configInt(Option.ACTION_BAR_UPDATE_PERIOD) * 50L, TimeUnit.MILLISECONDS);
        this.plugin.getScheduler().scheduleSync(() -> {
            Integer timerNum = this.timer.get(uuid);
            if (timerNum != null && timerNum.equals(0)) {
                this.isGainingXp.remove(uuid);
            }
        }, 2050L, TimeUnit.MILLISECONDS);
    }

    public void resetActionBars() {
        this.isGainingXp.clear();
        this.timer.clear();
        this.currentAction.clear();
        this.isPaused.clear();
        this.clearMessageCache();
    }

    public void resetActionBar(User user) {
        UUID uuid = user.getUuid();
        this.isGainingXp.remove(uuid);
        this.timer.remove(uuid);
        this.currentAction.remove(uuid);
        this.isPaused.remove(uuid);
    }

    public void setPaused(User user, int time, TimeUnit timeUnit) {
        UUID uuid = user.getUuid();
        this.isPaused.add(uuid);
        Integer action = this.currentAction.get(uuid);
        if (action != null) {
            this.currentAction.put(uuid, action + 1);
        } else {
            this.currentAction.put(uuid, 0);
        }
        int thisAction = this.currentAction.get(uuid);
        this.plugin.getScheduler().scheduleSync(() -> {
            Integer actionBarCurrentAction = this.currentAction.get(uuid);
            if (actionBarCurrentAction != null && thisAction == actionBarCurrentAction) {
                this.isPaused.remove(uuid);
            }
        }, time, timeUnit);
    }

    public void sendAbilityActionBar(User user, String message) {
        if (!user.isActionBarEnabled(ActionBarType.ABILITY)) {
            return;
        }
        boolean formatLast = this.plugin.configBoolean(Option.ACTION_BAR_FORMAT_LAST);
        String base = formatLast ? this.plugin.getMessageProvider().getRaw(ActionBarMessage.ABILITY, user.getLocale()) : this.plugin.getMsg(ActionBarMessage.ABILITY, user.getLocale());
        String actionBarText = TextUtil.replace(base, "{hp}", this.getHp(user), "{max_hp}", this.getMaxHp(user), "{mana}", this.getMana(user), "{max_mana}", this.getMaxMana(user), "{message}", message);
        actionBarText = this.replacePlaceholderApi(user, actionBarText);
        if (formatLast) {
            actionBarText = this.plugin.getMessageProvider().applyFormatting(actionBarText);
        }
        this.plugin.getUiProvider().sendActionBar(user, actionBarText);
        this.setPaused(user, 750, TimeUnit.MILLISECONDS);
    }

    private String getXpActionBarMessage(User user, Skill skill, double currentXp, double levelXp, double xpGained, int level, boolean maxed, double income) {
        ActionBarMessage messageKey = maxed ? ActionBarMessage.MAXED : ActionBarMessage.XP;
        Locale locale = user.getLocale();
        boolean formatLast = this.plugin.configBoolean(Option.ACTION_BAR_FORMAT_LAST);
        String base = formatLast ? this.plugin.getMessageProvider().getRaw(messageKey, locale) : this.plugin.getMsg(messageKey, locale);
        String message = TextUtil.replace(base, new String[]{"{hp}", this.getHp(user), "{max_hp}", this.getMaxHp(user), "{xp_gained}", xpGained > 0.0 ? "+" + NumberUtil.format1(xpGained) : NumberUtil.format1(xpGained), "{skill}", skill.getDisplayName(locale), "{current_xp}", this.plugin.getUiProvider().getFormat(UiProvider.FormatType.XP).format(currentXp), "{level_xp}", NumberUtil.format1(levelXp), "{skill_level}", String.valueOf(level), "{mana}", this.getMana(user), "{max_mana}", this.getMaxMana(user), "{income}", this.plugin.getUiProvider().getFormat(UiProvider.FormatType.MONEY).format(income)});
        message = this.replacePlaceholderApi(user, message);
        if (formatLast) {
            message = this.plugin.getMessageProvider().applyFormatting(message);
        }
        return message;
    }

    @NotNull
    public abstract String getHp(User var1);

    @NotNull
    public abstract String getMaxHp(User var1);

    @NotNull
    public abstract String getWorldName(User var1);

    private String getMana(User user) {
        return String.valueOf((int)Math.floor(user.getMana()));
    }

    private String getMaxMana(User user) {
        return String.valueOf((int)Math.floor(user.getMaxMana()));
    }

    private String replacePlaceholderApi(User user, String message) {
        if (this.plugin.getHookManager().isRegistered(PlaceholderHook.class) && this.plugin.configBoolean(Option.ACTION_BAR_PLACEHOLDER_API)) {
            return this.plugin.getHookManager().getHook(PlaceholderHook.class).setPlaceholders(user, message);
        }
        return message;
    }

    public void clearMessageCache() {
        this.idleMessageCache.clear();
    }
}

