/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.storage.file;

import dev.aurelium.auraskills.api.ability.AbstractAbility;
import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.TraitModifier;
import dev.aurelium.auraskills.api.util.AuraSkillsModifier;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.mana.ManaAbilityData;
import dev.aurelium.auraskills.common.ref.PlayerRef;
import dev.aurelium.auraskills.common.region.BlockPosition;
import dev.aurelium.auraskills.common.storage.StorageProvider;
import dev.aurelium.auraskills.common.ui.ActionBarType;
import dev.aurelium.auraskills.common.user.AntiAfkLog;
import dev.aurelium.auraskills.common.user.SkillLevelMaps;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.user.UserState;
import dev.aurelium.auraskills.common.util.data.KeyIntPair;
import dev.aurelium.auraskills.configurate.CommentedConfigurationNode;
import dev.aurelium.auraskills.configurate.ConfigurateException;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.serialize.SerializationException;
import dev.aurelium.auraskills.configurate.yaml.NodeStyle;
import dev.aurelium.auraskills.configurate.yaml.YamlConfigurationLoader;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileStorageProvider
extends StorageProvider {
    private final String dataDirectory;

    public FileStorageProvider(AuraSkillsPlugin plugin, String dataDirectory) {
        super(plugin);
        this.dataDirectory = dataDirectory;
    }

    @Override
    protected User loadRaw(UUID uuid, @Nullable PlayerRef platformPlayer) throws Exception {
        CommentedConfigurationNode root = this.loadYamlFile(uuid);
        User user = this.userManager.createNewUser(uuid, platformPlayer);
        if (root.empty()) {
            return user;
        }
        UUID loadedUuid = UUID.fromString(((CommentedConfigurationNode)root.node(new Object[]{"uuid"})).getString(uuid.toString()));
        if (!loadedUuid.equals(uuid)) {
            throw new IllegalStateException("UUID mismatch for player " + String.valueOf(uuid));
        }
        SkillLevelMaps skillLevelMaps = this.loadSkills(root.node(new Object[]{"skills"}));
        for (Map.Entry<Skill, Integer> entry : skillLevelMaps.levels().entrySet()) {
            Skill skill = entry.getKey();
            user.setSkillLevel(skill, entry.getValue());
            user.setSkillXp(skill, skillLevelMaps.xp().get(skill));
        }
        String localeString = ((CommentedConfigurationNode)root.node(new Object[]{"locale"})).getString();
        if (localeString != null) {
            localeString = localeString.replace("_", "-");
            Locale locale = Locale.forLanguageTag(localeString);
            user.setLocale(locale);
        }
        double mana = ((CommentedConfigurationNode)root.node(new Object[]{"mana"})).getDouble();
        user.setMana(mana);
        this.loadStatModifiers(root.node(new Object[]{"stat_modifiers"})).forEach((name, modifier) -> {
            if (modifier.isTemporary()) {
                user.getUserStats().addTemporaryStatModifier((StatModifier)modifier, false, modifier.getExpirationTime());
            } else {
                user.addStatModifier((StatModifier)modifier, false);
            }
        });
        this.loadTraitModifiers(root.node(new Object[]{"trait_modifiers"})).forEach((name, modifier) -> {
            if (modifier.isTemporary()) {
                user.getUserStats().addTemporaryTraitModifier((TraitModifier)modifier, false, modifier.getExpirationTime());
            } else {
                user.addTraitModifier((TraitModifier)modifier, false);
            }
        });
        this.loadAbilityData(root.node(new Object[]{"ability_data"}), user);
        this.loadUnclaimedItems(root.node(new Object[]{"unclaimed_items"}), user);
        this.loadActionBar(root.node(new Object[]{"action_bar"}), user);
        this.loadJobs(root.node(new Object[]{"jobs"}), user);
        long time = ((CommentedConfigurationNode)root.node(new Object[]{"last_job_select_time"})).getLong(0L);
        user.setLastJobSelectTime(time);
        return user;
    }

    private SkillLevelMaps loadSkills(ConfigurationNode node) {
        ConcurrentHashMap<Skill, Integer> levelsMap = new ConcurrentHashMap<Skill, Integer>();
        ConcurrentHashMap<Skill, Double> xpMap = new ConcurrentHashMap<Skill, Double>();
        node.childrenMap().forEach((skillName, skillNode) -> {
            NamespacedId skillId = NamespacedId.fromString(skillName.toString());
            Skill skill = (Skill)this.plugin.getSkillRegistry().getOrNull(skillId);
            if (skill == null) {
                return;
            }
            int level = skillNode.node("level").getInt();
            double xp = skillNode.node("xp").getDouble();
            levelsMap.put(skill, level);
            xpMap.put(skill, xp);
        });
        return new SkillLevelMaps(levelsMap, xpMap);
    }

    private Map<String, StatModifier> loadStatModifiers(ConfigurationNode node) {
        ConcurrentHashMap<String, StatModifier> statModifiers = new ConcurrentHashMap<String, StatModifier>();
        node.childrenMap().forEach((index, modifierNode) -> {
            String name = modifierNode.node("name").getString();
            String statName = modifierNode.node("stat").getString();
            double value = modifierNode.node("value").getDouble();
            String operationName = modifierNode.node("operation").getString(AuraSkillsModifier.Operation.ADD.toString());
            if (name != null && statName != null) {
                NamespacedId statId = NamespacedId.fromString(statName);
                Stat stat = (Stat)this.plugin.getStatRegistry().getOrNull(statId);
                if (stat == null) {
                    return;
                }
                StatModifier statModifier = new StatModifier(name, stat, value, AuraSkillsModifier.Operation.parse(operationName));
                statModifiers.put(name, statModifier);
                this.loadTemporary(statModifier, (ConfigurationNode)modifierNode);
            }
        });
        return statModifiers;
    }

    private Map<String, TraitModifier> loadTraitModifiers(ConfigurationNode node) {
        ConcurrentHashMap<String, TraitModifier> traitModifiers = new ConcurrentHashMap<String, TraitModifier>();
        node.childrenMap().forEach((index, modifierNode) -> {
            String name = modifierNode.node("name").getString();
            String traitName = modifierNode.node("trait").getString();
            double value = modifierNode.node("value").getDouble();
            String operationName = modifierNode.node("operation").getString(AuraSkillsModifier.Operation.ADD.toString());
            if (name != null && traitName != null) {
                NamespacedId traitId = NamespacedId.fromString(traitName);
                Trait trait = (Trait)this.plugin.getTraitRegistry().getOrNull(traitId);
                if (trait == null) {
                    return;
                }
                TraitModifier traitModifier = new TraitModifier(name, trait, value, AuraSkillsModifier.Operation.parse(operationName));
                traitModifiers.put(name, traitModifier);
                this.loadTemporary(traitModifier, (ConfigurationNode)modifierNode);
            }
        });
        return traitModifiers;
    }

    private void loadTemporary(AuraSkillsModifier<?> modifier, ConfigurationNode modifierNode) {
        long remainingDuration;
        long expirationTime = modifierNode.node("expiration_time").getLong(0L);
        if (expirationTime != 0L) {
            modifier.makeTemporary(expirationTime, false);
        }
        if ((remainingDuration = modifierNode.node("remaining_duration").getLong(0L)) != 0L) {
            modifier.makeTemporary(System.currentTimeMillis() + remainingDuration, true);
        }
    }

    private void loadAbilityData(ConfigurationNode node, User user) {
        node.childrenMap().forEach((abilityName, abilityNode) -> {
            NamespacedId abilityId = NamespacedId.fromString(abilityName.toString());
            AbstractAbility ability = this.plugin.getAbilityManager().getAbstractAbility(abilityId);
            abilityNode.childrenMap().forEach((key, value) -> {
                String keyStr = String.valueOf(key);
                if (keyStr.equals("cooldown") && ability instanceof ManaAbility) {
                    ManaAbility manaAbility = (ManaAbility)ability;
                    user.getManaAbilityData(manaAbility).setCooldown(value.getInt());
                } else {
                    user.getAbilityData(ability).setData((String)key, value.raw());
                }
            });
        });
    }

    private void loadUnclaimedItems(ConfigurationNode node, User user) {
        ArrayList<KeyIntPair> itemList = new ArrayList<KeyIntPair>();
        node.childrenList().forEach(itemNode -> {
            String itemString = itemNode.getString();
            if (itemString != null) {
                String[] split = itemString.split(" ");
                String itemName = split[0];
                int amount = Integer.parseInt(split[1]);
                itemList.add(new KeyIntPair(itemName, amount));
            }
        });
        user.setUnclaimedItems(itemList);
    }

    private void loadActionBar(ConfigurationNode node, User user) {
        for (ActionBarType type : ActionBarType.values()) {
            String typeName = type.toString().toLowerCase(Locale.ROOT);
            if (node.node(typeName).virtual()) continue;
            user.setActionBarSetting(type, node.node(typeName).getBoolean());
        }
    }

    private void loadJobs(ConfigurationNode node, User user) {
        user.clearAllJobs();
        for (ConfigurationNode configurationNode : node.childrenList()) {
            Skill skill;
            String skillName = configurationNode.getString();
            if (skillName == null || (skill = (Skill)this.plugin.getSkillRegistry().getOrNull(NamespacedId.fromString(skillName))) == null || !user.canSelectJob(skill)) continue;
            user.addJob(skill);
        }
    }

    @NotNull
    private CommentedConfigurationNode loadYamlFile(UUID uuid) throws ConfigurateException {
        Path path = Path.of(this.dataDirectory, uuid.toString() + ".yml");
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().defaultOptions(opts -> opts.shouldCopyDefaults(false))).path(path)).build();
        return (CommentedConfigurationNode)loader.load();
    }

    @Override
    @NotNull
    public UserState loadState(UUID uuid) throws Exception {
        CommentedConfigurationNode root = this.loadYamlFile(uuid);
        if (root.empty()) {
            return UserState.createEmpty(uuid, this.plugin);
        }
        UUID loadedUuid = UUID.fromString(((CommentedConfigurationNode)root.node(new Object[]{"uuid"})).getString(uuid.toString()));
        if (!loadedUuid.equals(uuid)) {
            throw new IllegalStateException("UUID mismatch for player " + String.valueOf(uuid));
        }
        SkillLevelMaps skillLevelMaps = this.loadSkills(root.node(new Object[]{"skills"}));
        double mana = ((CommentedConfigurationNode)root.node(new Object[]{"mana"})).getDouble();
        Map<String, StatModifier> statModifiers = this.loadStatModifiers(root.node(new Object[]{"stat_modifiers"}));
        Map<String, TraitModifier> traitModifiers = this.loadTraitModifiers(root.node(new Object[]{"trait_modifiers"}));
        return new UserState(uuid, skillLevelMaps.levels(), skillLevelMaps.xp(), statModifiers, traitModifiers, mana);
    }

    @Override
    public void applyState(UserState state) throws Exception {
        CommentedConfigurationNode root = this.loadYamlFile(state.uuid());
        ((CommentedConfigurationNode)root.node(new Object[]{"uuid"})).set(state.uuid().toString());
        ConfigurationNode skillsNode = root.node(new Object[]{"skills"});
        for (Skill skill : state.skillLevels().keySet()) {
            ConfigurationNode skillNode = skillsNode.node(skill.getId().toString());
            skillNode.node("level").set(state.skillLevels().get(skill));
            skillNode.node("xp").set(state.skillXp().get(skill));
        }
        ((CommentedConfigurationNode)root.node(new Object[]{"mana"})).set(state.mana());
        ConfigurationNode statModifiersNode = root.node(new Object[]{"stat_modifiers"});
        statModifiersNode.set(null);
        this.applyStatModifiers(statModifiersNode, state.statModifiers());
        ConfigurationNode traitModifiersNode = root.node(new Object[]{"trait_modifiers"});
        traitModifiersNode.set(null);
        this.applyTraitModifiers(traitModifiersNode, state.traitModifiers());
        this.saveYamlFile(root, state.uuid());
    }

    @Override
    public void save(@NotNull User user) throws Exception {
        CommentedConfigurationNode root = this.loadYamlFile(user.getUuid());
        ((CommentedConfigurationNode)root.node(new Object[]{"uuid"})).set(user.getUuid().toString());
        ConfigurationNode skillsNode = root.node(new Object[]{"skills"});
        for (Skill skill : user.getSkillLevelMap().keySet()) {
            ConfigurationNode skillNode = skillsNode.node(skill.getId().toString());
            skillNode.node("level").set(user.getSkillLevel(skill));
            skillNode.node("xp").set(user.getSkillXp(skill));
        }
        if (user.hasLocale()) {
            ((CommentedConfigurationNode)root.node(new Object[]{"locale"})).set(user.getLocale().toLanguageTag());
        }
        ((CommentedConfigurationNode)root.node(new Object[]{"mana"})).set(user.getMana());
        ConfigurationNode statModifiersNode = root.node(new Object[]{"stat_modifiers"});
        statModifiersNode.set(null);
        this.applyStatModifiers(statModifiersNode, user.getStatModifiers());
        ConfigurationNode traitModifiersNode = root.node(new Object[]{"trait_modifiers"});
        traitModifiersNode.set(null);
        this.applyTraitModifiers(traitModifiersNode, user.getTraitModifiers());
        ConfigurationNode abilityDataNode = root.node(new Object[]{"ability_data"});
        abilityDataNode.set(null);
        for (AbstractAbility abstractAbility : user.getAbilityDataMap().keySet()) {
            ConfigurationNode configurationNode = abilityDataNode.node(abstractAbility.getId().toString());
            for (Map.Entry<String, Object> entry : user.getAbilityData(abstractAbility).getDataMap().entrySet()) {
                configurationNode.node(entry.getKey()).set(entry.getValue());
            }
        }
        for (ManaAbilityData manaAbilityData : user.getManaAbilityDataMap().values()) {
            if (manaAbilityData.getCooldown() <= 0) continue;
            ConfigurationNode configurationNode = abilityDataNode.node(manaAbilityData.getManaAbility().getId().toString());
            configurationNode.node("cooldown").set(manaAbilityData.getCooldown());
        }
        ConfigurationNode unclaimedItemsNode = root.node(new Object[]{"unclaimed_items"});
        unclaimedItemsNode.set(null);
        for (KeyIntPair keyIntPair : user.getUnclaimedItems()) {
            unclaimedItemsNode.appendListNode().set(keyIntPair.getKey() + " " + keyIntPair.getValue());
        }
        ConfigurationNode configurationNode = root.node(new Object[]{"action_bar"});
        for (ActionBarType type : ActionBarType.values()) {
            if (type != ActionBarType.IDLE) continue;
            boolean value = user.isActionBarEnabled(type);
            configurationNode.node(type.toString().toLowerCase(Locale.ROOT)).set(value);
        }
        if (user.getJobs().isEmpty()) {
            root.removeChild("jobs");
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Skill skill : user.getJobs()) {
                arrayList.add(skill.getId().toString());
            }
            ((CommentedConfigurationNode)root.node(new Object[]{"jobs"})).set(arrayList);
        }
        long l = user.getLastJobSelectTime();
        if (l > 0L) {
            ((CommentedConfigurationNode)root.node(new Object[]{"last_job_select_time"})).set(l);
        }
        if (!user.getSessionAntiAfkLogs().isEmpty()) {
            ConfigurationNode node = root.node(new Object[]{"logs", "anti_afk"});
            List<ConfigurationNode> nodeList = node.getList(ConfigurationNode.class, new ArrayList());
            for (AntiAfkLog log : user.getSessionAntiAfkLogs()) {
                CommentedConfigurationNode logNode = CommentedConfigurationNode.root();
                ((CommentedConfigurationNode)logNode.node(new Object[]{"time"})).set(log.timestamp());
                ((CommentedConfigurationNode)logNode.node(new Object[]{"message"})).set(log.message());
                ((CommentedConfigurationNode)logNode.node(new Object[]{"coords"})).set(log.coords().toString());
                ((CommentedConfigurationNode)logNode.node(new Object[]{"world"})).set(log.world());
                nodeList.add(logNode);
            }
            node.setList(ConfigurationNode.class, nodeList);
        }
        this.saveYamlFile(root, user.getUuid());
    }

    private void saveYamlFile(CommentedConfigurationNode root, UUID uuid) throws ConfigurateException {
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(Path.of(this.dataDirectory, uuid.toString() + ".yml"))).defaultOptions(opts -> opts.shouldCopyDefaults(false))).nodeStyle(NodeStyle.BLOCK).indent(2).build();
        loader.save(root);
    }

    private void applyStatModifiers(ConfigurationNode node, Map<String, StatModifier> modifiers) throws Exception {
        int index = 0;
        for (StatModifier modifier : modifiers.values()) {
            if (modifier.isNonPersistent()) continue;
            ConfigurationNode modifierNode = node.node(String.valueOf(index));
            modifierNode.node("name").set(modifier.name());
            modifierNode.node("stat").set(modifier.stat().getId().toString());
            modifierNode.node("operation").set(modifier.operation().toString());
            modifierNode.node("value").set(modifier.value());
            this.applyTemporaryModifier(modifier, modifierNode);
            ++index;
        }
    }

    private void applyTraitModifiers(ConfigurationNode node, Map<String, TraitModifier> modifiers) throws Exception {
        int index = 0;
        for (TraitModifier modifier : modifiers.values()) {
            if (modifier.isNonPersistent()) continue;
            ConfigurationNode modifierNode = node.node(String.valueOf(index));
            modifierNode.node("name").set(modifier.name());
            modifierNode.node("trait").set(modifier.trait().getId().toString());
            modifierNode.node("operation").set(modifier.operation().toString());
            modifierNode.node("value").set(modifier.value());
            this.applyTemporaryModifier(modifier, modifierNode);
            ++index;
        }
    }

    private void applyTemporaryModifier(AuraSkillsModifier<?> modifier, ConfigurationNode modifierNode) throws SerializationException {
        if (modifier.isTemporary()) {
            if (modifier.isPauseOffline()) {
                modifierNode.node("remaining_duration").set(modifier.getExpirationTime() - System.currentTimeMillis());
            } else {
                modifierNode.node("expiration_time").set(modifier.getExpirationTime());
            }
        }
    }

    @Override
    public void delete(UUID uuid) throws Exception {
        Path path = Path.of(this.dataDirectory, uuid.toString() + ".yml");
        Files.deleteIfExists(path);
    }

    @Override
    public List<UserState> loadStates(boolean ignoreOnline, boolean skipKeyValues, long previousFetchTime) {
        ArrayList<UserState> states = new ArrayList<UserState>();
        File[] files = new File(this.dataDirectory).listFiles();
        if (files == null) {
            return states;
        }
        for (File file : files) {
            String fileName = file.getName();
            if (!fileName.endsWith(".yml")) continue;
            String uuidString = fileName.substring(0, fileName.length() - 4);
            try {
                UUID uuid = UUID.fromString(uuidString);
                if (ignoreOnline && this.userManager.hasUser(uuid)) continue;
                states.add(this.loadState(uuid));
            }
            catch (Exception e) {
                this.plugin.logger().warn("Invalid player data file name: " + fileName);
            }
        }
        return states;
    }

    @Override
    public List<AntiAfkLog> loadAntiAfkLogs(UUID uuid) {
        try {
            CommentedConfigurationNode root = this.loadYamlFile(uuid);
            if (root.empty()) {
                return new ArrayList<AntiAfkLog>();
            }
            ArrayList<AntiAfkLog> logs = new ArrayList<AntiAfkLog>();
            for (ConfigurationNode configurationNode : root.node("logs", "anti_afk").childrenList()) {
                long timestamp = configurationNode.node("time").getLong();
                String message = configurationNode.node("message").getString("");
                String coordsStr = configurationNode.node("coords").getString("");
                BlockPosition coords = BlockPosition.fromCommaString(coordsStr);
                String world = configurationNode.node("world").getString("");
                logs.add(new AntiAfkLog(timestamp, message, coords, world));
            }
            return logs;
        }
        catch (ConfigurateException e) {
            this.plugin.logger().warn("Failed to load anti-AFK logs from storage for UUID " + String.valueOf(uuid));
            e.printStackTrace();
            return new ArrayList<AntiAfkLog>();
        }
    }
}

