/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.storage;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.ref.PlayerRef;
import dev.aurelium.auraskills.common.scheduler.TaskRunnable;
import dev.aurelium.auraskills.common.user.AntiAfkLog;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.user.UserManager;
import dev.aurelium.auraskills.common.user.UserState;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StorageProvider {
    private static final long SAVE_TIMEOUT_MS = 2000L;
    private static final long LOAD_TIMEOUT_MS = 2000L;
    public final AuraSkillsPlugin plugin;
    public final UserManager userManager;
    private final ConcurrentHashMap<UUID, ReentrantReadWriteLock> userLocks = new ConcurrentHashMap();

    public StorageProvider(AuraSkillsPlugin plugin) {
        this.userManager = plugin.getUserManager();
        this.plugin = plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(UUID uuid, @Nullable PlayerRef platformPlayer) throws Exception {
        ReentrantReadWriteLock lock = this.getUserLock(uuid);
        boolean lockAcquired = false;
        try {
            lockAcquired = lock.readLock().tryLock(2000L, TimeUnit.MILLISECONDS);
            if (!lockAcquired) {
                this.plugin.logger().warn("Load timout exceeded for user " + String.valueOf(uuid));
            }
            User user = this.loadRaw(uuid, platformPlayer);
            this.fixInvalidData(user);
            this.plugin.getUserManager().addUser(user);
            this.plugin.getScheduler().executeSync(() -> {
                this.plugin.getStatManager().recalculateStats(user, false);
                this.plugin.getModifierManager().applyModifiers(user, false);
                this.plugin.getStatManager().reloadAllTraits(user);
                this.plugin.getEventHandler().callUserLoadEvent(user);
            });
            this.plugin.getRewardManager().updatePermissions(user);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            if (lockAcquired) {
                lock.readLock().unlock();
            }
            this.removeUserLock(uuid, lock);
        }
    }

    protected abstract User loadRaw(UUID var1, PlayerRef var2) throws Exception;

    @NotNull
    public abstract UserState loadState(UUID var1) throws Exception;

    public abstract void applyState(UserState var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSafely(@NotNull User user) {
        ReentrantReadWriteLock lock = this.getUserLock(user.getUuid());
        boolean lockAcquired = false;
        try {
            lockAcquired = lock.writeLock().tryLock(2000L, TimeUnit.MILLISECONDS);
            if (!lockAcquired) {
                this.plugin.logger().warn("Save timeout exceeded for user " + String.valueOf(user.getUuid()));
                return;
            }
            this.save(user);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (lockAcquired) {
                lock.writeLock().unlock();
            }
            this.removeUserLock(user.getUuid(), lock);
        }
    }

    public abstract void save(@NotNull User var1) throws Exception;

    public abstract void delete(UUID var1) throws Exception;

    public List<UserState> loadStates(boolean ignoreOnline, boolean skipKeyValues) throws Exception {
        return this.loadStates(ignoreOnline, skipKeyValues, 0L);
    }

    public abstract List<UserState> loadStates(boolean var1, boolean var2, long var3) throws Exception;

    public abstract List<AntiAfkLog> loadAntiAfkLogs(UUID var1);

    public void startAutoSaving() {
        if (!this.plugin.configBoolean(Option.AUTO_SAVE_ENABLED)) {
            return;
        }
        long interval = this.plugin.configInt(Option.AUTO_SAVE_INTERVAL_TICKS);
        TaskRunnable task = new TaskRunnable(){

            @Override
            public void run() {
                for (User user : StorageProvider.this.userManager.getOnlineUsers()) {
                    try {
                        StorageProvider.this.saveSafely(user);
                    }
                    catch (Exception e) {
                        StorageProvider.this.plugin.logger().warn("Error running auto-save on user data:");
                        e.printStackTrace();
                    }
                }
            }
        };
        this.plugin.getScheduler().timerAsync(task, interval * 50L, interval * 50L, TimeUnit.MILLISECONDS);
    }

    private void fixInvalidData(User user) {
        int startLevel = this.plugin.config().getStartLevel();
        for (Skill skill : user.getSkillLevelMap().keySet()) {
            if (user.getSkillLevel(skill) >= startLevel) continue;
            user.setSkillLevel(skill, startLevel);
        }
        if (this.plugin.configBoolean(Option.DATA_VALIDATION_CORRECT_OVER_MAX_LEVEL)) {
            for (Skill skill : user.getSkillLevelMap().keySet()) {
                int maxLevel = skill.getMaxLevel();
                if (user.getSkillLevelMap().get(skill) <= maxLevel) continue;
                user.setSkillLevel(skill, maxLevel);
            }
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        for (StatModifier modifier : user.getStatModifiers().values()) {
            if (modifier.name().startsWith("AureliumSkills.Modifier")) {
                toRemove.add(modifier.name());
            }
            if (!modifier.name().startsWith("AuraSkills.Modifiers.") && !modifier.name().startsWith("AuraSkills.TraitModifiers.") || modifier.isNonPersistent()) continue;
            toRemove.add(modifier.name());
        }
        toRemove.forEach(s -> user.removeStatModifier((String)s, false));
    }

    protected ReentrantReadWriteLock getUserLock(UUID uuid) {
        return this.userLocks.computeIfAbsent(uuid, id -> new ReentrantReadWriteLock());
    }

    protected void removeUserLock(UUID uuid, ReentrantReadWriteLock lock) {
        if (lock.getReadLockCount() == 0 && !lock.isWriteLocked()) {
            this.userLocks.remove(uuid);
        }
    }
}

