/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.storage;

import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.storage.StorageProvider;
import dev.aurelium.auraskills.common.storage.StorageType;
import dev.aurelium.auraskills.common.storage.file.FileStorageProvider;
import dev.aurelium.auraskills.common.storage.sql.DatabaseCredentials;
import dev.aurelium.auraskills.common.storage.sql.SqlStorageProvider;
import dev.aurelium.auraskills.common.storage.sql.pool.MySqlConnectionPool;

public abstract class StorageFactory {
    protected final AuraSkillsPlugin plugin;

    public StorageFactory(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
    }

    public StorageProvider createStorageProvider(StorageType type) {
        switch (type) {
            case MYSQL: {
                MySqlConnectionPool pool = new MySqlConnectionPool(this.plugin, this.getCredentials());
                pool.enable();
                return new SqlStorageProvider(this.plugin, pool);
            }
            case YAML: {
                return new FileStorageProvider(this.plugin, this.getDataDirectory());
            }
        }
        throw new IllegalArgumentException("Unknown storage type: " + String.valueOf((Object)type));
    }

    public abstract String getDataDirectory();

    private DatabaseCredentials getCredentials() {
        return new DatabaseCredentials(this.plugin.configString(Option.SQL_HOST), this.plugin.configInt(Option.SQL_PORT), this.plugin.configString(Option.SQL_DATABASE), this.plugin.configString(Option.SQL_USERNAME), this.plugin.configString(Option.SQL_PASSWORD), this.plugin.configBoolean(Option.SQL_SSL));
    }
}

