/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.stat;

import dev.aurelium.auraskills.api.stat.ReloadableIdentifier;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.scheduler.TaskRunnable;
import dev.aurelium.auraskills.common.stat.LoadedStat;
import dev.aurelium.auraskills.common.stat.StatSupplier;
import dev.aurelium.auraskills.common.user.User;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public abstract class StatManager {
    protected final AuraSkillsPlugin plugin;
    private final Map<Stat, LoadedStat> statMap;
    private final StatSupplier supplier;

    public StatManager(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        this.statMap = new LinkedHashMap<Stat, LoadedStat>();
        this.supplier = new StatSupplier(this, plugin.getMessageProvider());
    }

    public StatSupplier getSupplier() {
        return this.supplier;
    }

    @NotNull
    public LoadedStat getStat(Stat stat) {
        LoadedStat loadedStat = this.statMap.get(stat);
        if (loadedStat == null) {
            throw new IllegalArgumentException("Stat " + String.valueOf(stat) + " is not loaded!");
        }
        return loadedStat;
    }

    public Collection<LoadedStat> getStats() {
        return this.statMap.values();
    }

    public Set<Stat> getEnabledStats() {
        LinkedHashSet<Stat> stats = new LinkedHashSet<Stat>();
        for (LoadedStat loaded : this.statMap.values()) {
            if (!loaded.options().enabled()) continue;
            stats.add(loaded.stat());
        }
        return stats;
    }

    public void register(Stat stat, LoadedStat loadedStat) {
        this.statMap.put(stat, loadedStat);
    }

    public void unregisterAll() {
        this.statMap.clear();
    }

    public abstract <T extends ReloadableIdentifier> void reload(User var1, T var2);

    public abstract void reloadAllTraits(User var1);

    public void recalculateStats(User user) {
        this.recalculateStats(user, true);
    }

    public void recalculateStats(User user, boolean reload) {
        if (user == null) {
            return;
        }
        for (Stat stat : this.plugin.getStatRegistry().getValues()) {
            user.getUserStats().recalculateStat(stat);
        }
        if (reload) {
            this.reloadAllTraits(user);
        }
    }

    public boolean isLoaded(Stat stat) {
        return this.statMap.containsKey(stat);
    }

    public void scheduleTemporaryModifierTask() {
        if (!this.plugin.configBoolean(Option.MODIFIER_TEMPORARY_ENABLED)) {
            return;
        }
        TaskRunnable task = new TaskRunnable(){

            @Override
            public void run() {
                for (User user : StatManager.this.plugin.getUserManager().getOnlineUsers()) {
                    user.getUserStats().removeExpiredModifiers();
                }
            }
        };
        this.plugin.getScheduler().timerSync(task, 0L, (long)this.plugin.configInt(Option.MODIFIER_TEMPORARY_CHECK_PERIOD) * 50L, TimeUnit.MILLISECONDS);
    }
}

