/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.source;

import dev.aurelium.auraskills.api.AuraSkillsApi;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.source.SourceType;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.api.ApiAuraSkills;
import dev.aurelium.auraskills.common.source.parser.AnvilSourceParser;
import dev.aurelium.auraskills.common.source.parser.BlockSourceParser;
import dev.aurelium.auraskills.common.source.parser.BrewingSourceParser;
import dev.aurelium.auraskills.common.source.parser.DamageSourceParser;
import dev.aurelium.auraskills.common.source.parser.EnchantingSourceParser;
import dev.aurelium.auraskills.common.source.parser.EntitySourceParser;
import dev.aurelium.auraskills.common.source.parser.FishingSourceParser;
import dev.aurelium.auraskills.common.source.parser.GrindstoneSourceParser;
import dev.aurelium.auraskills.common.source.parser.ItemConsumeSourceParser;
import dev.aurelium.auraskills.common.source.parser.JumpingSourceParser;
import dev.aurelium.auraskills.common.source.parser.ManaAbilityUseSourceParser;
import dev.aurelium.auraskills.common.source.parser.PotionSplashSourceParser;
import dev.aurelium.auraskills.common.source.parser.SourceParser;
import dev.aurelium.auraskills.common.source.parser.StatisticSourceParser;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;

public enum SourceTypes implements SourceType
{
    ANVIL(AnvilSourceParser.class),
    BLOCK(BlockSourceParser.class),
    BREWING(BrewingSourceParser.class),
    DAMAGE(DamageSourceParser.class),
    ENCHANTING(EnchantingSourceParser.class),
    ENTITY(EntitySourceParser.class),
    FISHING(FishingSourceParser.class),
    GRINDSTONE(GrindstoneSourceParser.class),
    ITEM_CONSUME(ItemConsumeSourceParser.class),
    JUMPING(JumpingSourceParser.class),
    MANA_ABILITY_USE(ManaAbilityUseSourceParser.class),
    POTION_SPLASH(PotionSplashSourceParser.class),
    STATISTIC(StatisticSourceParser.class);

    private final NamespacedId id = NamespacedId.of("auraskills", this.name().toLowerCase(Locale.ROOT));
    private final Class<? extends SourceParser<?>> parserClass;

    private SourceTypes(Class<? extends SourceParser<?>> parserClass) {
        this.parserClass = parserClass;
    }

    @Override
    public NamespacedId getId() {
        return this.id;
    }

    public SourceParser<?> getParser() {
        AuraSkillsPlugin plugin = ((ApiAuraSkills)AuraSkillsApi.get()).getPlugin();
        try {
            return (SourceParser)this.parserClass.getConstructors()[0].newInstance(plugin);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException("Could not instantiate parser class " + this.parserClass.getName());
        }
    }

    @Override
    public boolean isEnabled() {
        AuraSkillsPlugin plugin = ((ApiAuraSkills)AuraSkillsApi.get()).getPlugin();
        return plugin.getSkillManager().isSourceEnabled(this);
    }
}

